/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.coverage;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.primitives.Ints;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class ClassInfo {
    static final String NO_CLASSES_TO_DISPLAY_FOR_MODULE_MESSAGE = "No classes to display for module.";
    private String name;
    private String lineRate;
    private String branchRate;

    public static void printCoverageReport(Collection<ClassInfo> classInfos, PrintWriter printWriter) {
        Collection<ClassInfo> classInfosNullFiltered = Collections2.filter(classInfos, Predicates.notNull());
        int lineRateColLength = Math.max(5, "Line Rate".length());
        int branchRateColLength = Math.max(5, "Branch Rate".length());
        int maxNameLength = classInfosNullFiltered.isEmpty() ? 20 : Collections.max(classInfosNullFiltered, new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo o1, ClassInfo o2) {
                return Ints.compare(o1.getName().length(), o2.getName().length());
            }
        }).getName().length();
        int classColLength = Math.max(maxNameLength, "Class Name".length());
        printWriter.printf("%s%n", StringUtils.repeat("=", classColLength + 1 + lineRateColLength + 3 + branchRateColLength));
        printWriter.printf(String.format("%%-%ds %%%ds   %%%ds%%n", classColLength, lineRateColLength, branchRateColLength), "Class Name", "Line Rate", "Branch Rate");
        if (classInfosNullFiltered.isEmpty()) {
            printWriter.printf("%s%n", NO_CLASSES_TO_DISPLAY_FOR_MODULE_MESSAGE);
        } else {
            for (ClassInfo classInfo : classInfosNullFiltered) {
                printWriter.printf(String.format("%%-%ds %%%ds   %%%ds%%n", classColLength, lineRateColLength, branchRateColLength), classInfo.getName(), classInfo.getLineRate(), classInfo.getBranchRate());
            }
        }
        printWriter.printf("%s%n", StringUtils.repeat("=", classColLength + 1 + lineRateColLength + 3 + branchRateColLength));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    ClassInfo withName(String name) {
        this.setName(name);
        return this;
    }

    public String getLineRate() {
        return this.lineRate;
    }

    public void setLineRate(String lineRate) {
        this.lineRate = lineRate;
    }

    public void setLineRate(float lineRate) {
        this.lineRate = String.format("%.1f", Float.valueOf(lineRate));
    }

    ClassInfo withLineRate(String lineRate) {
        this.setLineRate(lineRate);
        return this;
    }

    public String getBranchRate() {
        return this.branchRate;
    }

    public void setBranchRate(String branchRate) {
        this.branchRate = branchRate;
    }

    public void setBranchRate(float branchRate) {
        this.branchRate = String.format("%.1f", Float.valueOf(branchRate));
    }

    ClassInfo withBranchRate(String branchRate) {
        this.setBranchRate(branchRate);
        return this;
    }

    public static class NameMatchesPredicate
    implements Predicate<ClassInfo> {
        String nameToMatch;

        public NameMatchesPredicate(String nameToMatch) {
            this.nameToMatch = nameToMatch;
        }

        @Override
        public boolean apply(ClassInfo input) {
            return input.getName().equals(this.nameToMatch);
        }
    }
}

