/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.coverage;

import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CoverageSummary
extends Task {
    private List<FileSet> ratesFileSets = new ArrayList<FileSet>();
    private String compareTo;

    public void addFileset(FileSet ratesFileSet) {
        this.ratesFileSets.add(ratesFileSet);
    }

    public void setCompareTo(String compareTo) {
        this.compareTo = compareTo.trim();
    }

    @Override
    public void execute() {
        if (this.ratesFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        TreeMap<String, Properties> ratesMap = new TreeMap<String, Properties>();
        TreeMap<String, Properties> comparisonRatesMap = new TreeMap<String, Properties>();
        for (FileSet ratesFileSet : this.ratesFileSets) {
            DirectoryScanner scanner = ratesFileSet.getDirectoryScanner(this.getProject());
            for (String ratesFileName : scanner.getIncludedFiles()) {
                File ratesFile = new File(scanner.getBasedir(), ratesFileName);
                try {
                    Properties rates = this.readRates(new BufferedInputStream(new FileInputStream(ratesFile)));
                    ratesMap.put(rates.getProperty("module.name"), rates);
                }
                catch (FileNotFoundException e) {
                    throw new BuildException(e);
                }
                InputStream comparisonStream = this.getComparisonStream(scanner.getBasedir(), ratesFileName);
                if (comparisonStream == null) continue;
                Properties comparisonRates = this.readRates(new BufferedInputStream(comparisonStream));
                comparisonRatesMap.put(comparisonRates.getProperty("module.name"), comparisonRates);
            }
        }
        this.printSummary(ratesMap, comparisonRatesMap);
    }

    private InputStream getComparisonStream(File baseDir, String ratesFileName) {
        if (Strings.isNullOrEmpty(this.compareTo)) {
            return null;
        }
        try {
            URL compareToUrl = new URL(this.compareTo + "/" + ratesFileName);
            try {
                return compareToUrl.openStream();
            }
            catch (IOException e) {
                this.log("Cannot open comparison url: " + compareToUrl, e, 1);
                return null;
            }
        }
        catch (MalformedURLException e) {
            File compareToFile = this.compareTo.startsWith("/") ? new File(new File(this.compareTo), ratesFileName) : new File(new File(baseDir, this.compareTo), ratesFileName);
            try {
                return new FileInputStream(compareToFile);
            }
            catch (FileNotFoundException fnfe) {
                this.log("Cannot open comparison file: " + compareToFile, fnfe, 1);
                return null;
            }
        }
    }

    private Properties readRates(InputStream ratesStream) {
        Properties properties;
        try {
            properties = new Properties();
            properties.load(ratesStream);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        finally {
            try {
                ratesStream.close();
            }
            catch (IOException e) {}
        }
        return properties;
    }

    private void printSummary(SortedMap<String, Properties> ratesMap, SortedMap<String, Properties> comparisonRatesMap) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printSeparator(printWriter, comparisonRatesMap);
        printWriter.print(" MODULE                    STAT      REQ(R)  MEASURED(M)  M-R");
        if (!comparisonRatesMap.isEmpty()) {
            printWriter.print("   COMPARE(C)  M-C");
        }
        printWriter.println();
        for (Map.Entry<String, Properties> entry : ratesMap.entrySet()) {
            Properties comparisonProperties;
            Properties properties = entry.getValue();
            this.printStandardLine(printWriter, entry.getKey(), "line", Integer.parseInt(properties.getProperty("required.lineRate")), Integer.parseInt(properties.getProperty("measured.lineRate")));
            if (!comparisonRatesMap.isEmpty() && (comparisonProperties = (Properties)comparisonRatesMap.get(entry.getKey())) != null) {
                this.printComparisonLine(printWriter, Integer.parseInt(comparisonProperties.getProperty("measured.lineRate")), Integer.parseInt(properties.getProperty("measured.lineRate")));
            }
            printWriter.println();
            this.printStandardLine(printWriter, entry.getKey(), "branch", Integer.parseInt(properties.getProperty("required.branchRate")), Integer.parseInt(properties.getProperty("measured.branchRate")));
            if (!comparisonRatesMap.isEmpty() && (comparisonProperties = (Properties)comparisonRatesMap.get(entry.getKey())) != null) {
                this.printComparisonLine(printWriter, Integer.parseInt(comparisonProperties.getProperty("measured.branchRate")), Integer.parseInt(properties.getProperty("measured.branchRate")));
            }
            printWriter.println();
        }
        this.printSeparator(printWriter, comparisonRatesMap);
        printWriter.flush();
        this.getProject().log(stringWriter.toString(), 2);
    }

    private void printSeparator(PrintWriter printWriter, SortedMap<String, Properties> comparisonRatesMap) {
        printWriter.print("=============================================================");
        if (!comparisonRatesMap.isEmpty()) {
            printWriter.print("   ===============");
        }
        printWriter.println();
    }

    private void printStandardLine(PrintWriter printWriter, String moduleName, String stat, int requiredRate, int measuredRate) {
        printWriter.printf(" %-26s%-10s%3d     %8d     %3d", moduleName, stat, requiredRate, measuredRate, measuredRate - requiredRate);
    }

    private void printComparisonLine(PrintWriter printWriter, int comparisonMeasuredRate, int measuredRate) {
        printWriter.printf("   %7d     %3d", comparisonMeasuredRate, measuredRate - comparisonMeasuredRate);
    }
}

