/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.eclipse;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class EclipseClasspath
extends Task {
    private static final String PROPERTY_ECLIPSE_CLASSPATH = "eclipse.classpath";
    private static final String PROPERTY_IVY_CONTAINER = "eclipse.ivy.container";
    private boolean exportIvyContainer;
    private String outputPath = "target/package";
    private String testOutputPath = "target/package-test";

    public void setExportIvyContainer(boolean exportIvyContainer) {
        this.exportIvyContainer = exportIvyContainer;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setTestOutputPath(String testOutputPath) {
        this.testOutputPath = testOutputPath;
    }

    @Override
    public void execute() {
        ArrayList<String> lines = Lists.newArrayList();
        lines.add("");
        lines.add("<!-- START - Classpath entries generated by AXX -->");
        lines.add("");
        lines.add(this.getClasspathEntry("src", "src/main/webapp", null, false));
        lines.add(this.getClasspathEntry("src", "src/main/groovy", null, false));
        lines.add(this.getClasspathEntry("src", "src/main/java", null, false));
        lines.add(this.getClasspathEntry("src", "src/main/resources", null, false));
        lines.add(this.getClasspathEntry("src", "target/generated/src/main/java", null, false));
        lines.add(this.getClasspathEntry("src", "target/generated/src/main/resources", null, false));
        lines.add(this.getClasspathEntry("src", "src/bootstrap/java", "target/package-bootstrap", false));
        lines.add(this.getClasspathEntry("src", "src/bootstrap/resources", "target/package-bootstrap", false));
        lines.add(this.getClasspathEntry("src", "src/test/java", this.testOutputPath, false));
        lines.add(this.getClasspathEntry("src", "src/test/resources", this.testOutputPath, false));
        lines.add(this.getClasspathEntry("src", "src/test-gwt/java", this.testOutputPath, false));
        lines.add(this.getClasspathEntry("src", "target/generated/src/test/java", this.testOutputPath, false));
        lines.add(this.getClasspathEntry("src", "target/generated/src/test/resources", this.testOutputPath, false));
        lines.add(this.getClasspathEntry("con", "org.eclipse.jdt.launching.JRE_CONTAINER", null, false));
        String ivyClasspathEntry = this.getClasspathEntry("con", this.getIvyContainerPath(), null, this.exportIvyContainer);
        lines.add(ivyClasspathEntry);
        lines.add(this.getClasspathEntry("output", this.outputPath, null, false));
        lines.add("");
        lines.add("<!-- END - Classpath entries generated by AXX -->");
        lines.add("");
        this.getProject().setProperty(PROPERTY_IVY_CONTAINER, ivyClasspathEntry);
        this.getProject().setProperty(PROPERTY_ECLIPSE_CLASSPATH, Joiner.on(String.format("%n    ", new Object[0])).skipNulls().join(lines));
    }

    @SuppressFBWarnings(value={"BL_BURYING_LOGIC"})
    private String getClasspathEntry(String kind, String path, String output, boolean export) {
        if (!"src".equals(kind) || this.isNotEmpty(new File(this.getProject().getBaseDir(), path))) {
            StringBuilder builder = new StringBuilder();
            builder.append("<classpathentry kind=\"").append(kind).append("\" path=\"").append(path).append('\"');
            if (output != null) {
                builder.append(" output=\"").append(output).append('\"');
            }
            if (export) {
                builder.append(" exported=\"true\"");
            }
            builder.append("/>");
            return builder.toString();
        }
        return null;
    }

    private boolean isNotEmpty(File file) {
        return file.isDirectory() && !ArrayUtils.isEmpty(file.list());
    }

    private String getIvyContainerPath() {
        String ivySettingsFile = this.getProject().getProperty("eclipse.ivy.settings.file");
        String eclipseIvyConfs = this.getProject().getProperty("eclipse.ivy.confs");
        ArrayList<String> properties = Lists.newArrayList();
        properties.add(this.getProperty("project", this.getProject().getName()));
        properties.add(this.getProperty("ivyXmlPath", "ivy.xml"));
        properties.add(this.getProperty("confs", eclipseIvyConfs));
        properties.add(this.getProperty("ivySettingsPath", "file:" + ivySettingsFile));
        properties.add(this.getProperty("loadSettingsOnDemand", "false"));
        properties.add(this.getProperty("propertyFiles", this.getPropertiesFiles()));
        properties.add(this.getProperty("resolveInWorkspace", "true"));
        properties.add(this.getProperty("acceptedTypes", "jar,bundle,ejb,maven-plugin"));
        StringBuilder path = new StringBuilder(100);
        path.append("org.apache.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER/?");
        Joiner.on("&amp;").skipNulls().appendTo(path, (Iterable<?>)properties);
        return path.toString();
    }

    private String getPropertiesFiles() {
        String axxDirRelativeToRootDir;
        String rootDir = this.getProject().getProperty("root.dir");
        String axxDir = this.getProject().getProperty("axx.dir");
        try {
            axxDirRelativeToRootDir = FileUtils.getRelativePath((File)new File(rootDir), (File)new File(axxDir));
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
        String userHome = this.getProject().getProperty("user.home");
        String eclipseRootDir = this.getProject().getProperty("eclipse.root.dir");
        String eclipseUserHome = this.getProject().getProperty("eclipse.user.home");
        ArrayList<String> propertyFiles = Lists.newArrayList();
        propertyFiles.add(this.getPropertyFile(rootDir, eclipseRootDir, "eclipse.properties"));
        propertyFiles.add(this.getPropertyFile(axxDir, eclipseRootDir + SystemUtils.FILE_SEPARATOR + axxDirRelativeToRootDir, "axx.properties"));
        propertyFiles.add(this.getPropertyFile(rootDir, eclipseRootDir, "build.properties"));
        propertyFiles.add(this.getPropertyFile(userHome, eclipseUserHome, ".netapp-build/build-user.properties"));
        propertyFiles.add(this.getPropertyFile(rootDir, eclipseRootDir, "build-local.properties"));
        return Joiner.on(',').skipNulls().join(propertyFiles);
    }

    @SuppressFBWarnings(value={"BL_BURYING_LOGIC"})
    private String getPropertyFile(String existanceCheckBaseDir, String eclipseBaseDir, String relativePath) {
        if (new File(existanceCheckBaseDir, relativePath).exists()) {
            return eclipseBaseDir + "/" + relativePath;
        }
        return null;
    }

    private String getProperty(String name, String value) {
        return name + "=" + this.urlEncode(value);
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

