/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.finddirs;

import com.netapp.common.util.CollectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class FindDirsRemovedFromP4
extends Task {
    private String parentDir;
    private String p4Executable = "p4";
    private String outputProperty = "dirsRemovedFromP4";

    public void setParentDir(String parentDir) {
        this.parentDir = parentDir;
    }

    public void setP4Executable(String p4Executable) {
        this.p4Executable = p4Executable;
    }

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }

    @Override
    public void execute() {
        Set<String> deletedSubdirNamesFromP4 = this.retrieveDeletedSubDirectoryNamesFromP4();
        Set<String> subdirNamesFromFileSystem = this.retrieveSubDirectoryNamesFromFileSystem();
        subdirNamesFromFileSystem.retainAll(deletedSubdirNamesFromP4);
        if (!subdirNamesFromFileSystem.isEmpty()) {
            this.getProject().setProperty(this.outputProperty, CollectionUtils.collectionToString(subdirNamesFromFileSystem, (String)SystemUtils.LINE_SEPARATOR, (String)(this.parentDir + File.separator), (String)""));
        }
    }

    private Set<String> retrieveDeletedSubDirectoryNamesFromP4() {
        Set<String> currentDirs = this.retrieveSubDirectoryNamesFromP4(false);
        this.log("Current directories in p4: " + currentDirs, 4);
        Set<String> allDirs = this.retrieveSubDirectoryNamesFromP4(true);
        this.log("All directories in p4 (including deleted): " + allDirs, 4);
        allDirs.removeAll(currentDirs);
        this.log("Directories that have been deleted from p4: " + allDirs, 4);
        return allDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> retrieveSubDirectoryNamesFromP4(boolean includeDeleted) {
        HashSet<String> hashSet;
        String[] stringArray;
        if (includeDeleted) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = this.p4Executable;
            stringArray2[1] = "dirs";
            stringArray2[2] = "-D";
            stringArray = stringArray2;
            stringArray2[3] = this.parentDir + File.separator + "*";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = this.p4Executable;
            stringArray3[1] = "dirs";
            stringArray = stringArray3;
            stringArray3[2] = this.parentDir + File.separator + "*";
        }
        String[] command = stringArray;
        Process p = Runtime.getRuntime().exec(command, null, this.getProject().getBaseDir());
        HashSet<String> subdirNames = new HashSet<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                subdirNames.add(line.substring(line.lastIndexOf(47) + 1));
            }
            hashSet = subdirNames;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            catch (IOException e) {
                throw new BuildException(String.format("Unable to retrieve directory names from P4: %s", e.getMessage()), e);
            }
        }
        IOUtils.closeQuietly(reader);
        return hashSet;
    }

    private Set<String> retrieveSubDirectoryNamesFromFileSystem() {
        File[] subDirectories = new File(this.parentDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashSet<String> subdirNames = new HashSet<String>();
        for (File subDirectory : subDirectories) {
            subdirNames.add(subDirectory.getName());
        }
        this.log("Directories found in the filesystem: " + subdirNames, 4);
        return subdirNames;
    }
}

