/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.gwt;

import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.tools.GWTTestSuite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Properties;
import junit.framework.TestSuite;
import org.junit.Ignore;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class DynamicGwtTestSuite {
    private DynamicGwtTestSuite() {
    }

    public static TestSuite suite() throws ClassNotFoundException {
        GWTTestSuite suite = new GWTTestSuite();
        for (String gwtTestFile : DynamicGwtTestSuite.getCandidateGwtTestFiles()) {
            Class<?> testClass = Class.forName(DynamicGwtTestSuite.classNameFromFilePath(gwtTestFile));
            if (!GWTTestCase.class.isAssignableFrom(testClass) || Modifier.isAbstract(testClass.getModifiers()) || Modifier.isInterface(testClass.getModifiers()) || testClass.isAnnotationPresent(Ignore.class)) continue;
            suite.addTestSuite(testClass);
        }
        return suite;
    }

    private static String[] getCandidateGwtTestFiles() {
        String gwtTestIncludeFileProperty = System.getProperty("gwt.test.include.file");
        if (gwtTestIncludeFileProperty == null) {
            throw new RuntimeException("Expected 'gwt.test.include.file' system property to be set to the name of a file containing a single test.files property whose value is a comma separated list of java file paths");
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(gwtTestIncludeFileProperty);
            Properties properties = new Properties();
            properties.load(fileReader);
            String gwtTestFilesProperty = properties.getProperty("test.files");
            if (gwtTestFilesProperty == null) {
                throw new RuntimeException("Expected " + gwtTestIncludeFileProperty + " to contain a single test.files property whose value is a comma separated list of java file paths");
            }
            String[] stringArray = gwtTestFilesProperty.split(",");
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading test.files property from " + gwtTestIncludeFileProperty, e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String classNameFromFilePath(String gwtTestFile) {
        return gwtTestFile.replace(".java", "").replaceAll("[/\\\\]", ".");
    }
}

