/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.idea;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class GenerateModulesXml
extends Task {
    private FileSet buildFileSet;
    private File outputFile;

    @Override
    public void execute() {
        if (this.outputFile.exists()) {
            throw new BuildException(this.outputFile.getName() + " already exists");
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(this.outputFile);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<!-- Generated by AXX -->");
            writer.println("<project version=\"4\">");
            writer.println("  <component name=\"ProjectModuleManager\">");
            writer.println("    <modules>");
            DirectoryScanner scanner = this.buildFileSet.getDirectoryScanner(this.getProject());
            for (String buildFileName : scanner.getIncludedFiles()) {
                writer.format("      <module fileurl=\"file://$PROJECT_DIR$/%s\" filepath=\"$PROJECT_DIR$/%1$s\" />%n", buildFileName);
            }
            writer.println("    </modules>");
            writer.println("  </component>");
            writer.println("</project>");
        }
        catch (IOException e) {
            try {
                throw new BuildException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(writer);
                throw throwable;
            }
        }
        FileUtils.close(writer);
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void addFileset(FileSet buildFileSet) {
        this.buildFileSet = buildFileSet;
    }
}

