/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.ivy;

import com.netapp.axx.ivy.DebugConflictException;
import com.netapp.axx.ivy.VerboseConflictException;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.version.VersionMatcher;

public class StrictWithForceConflictManager
extends StrictConflictManager {
    @Override
    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        if (conflicts.size() < 2) {
            return conflicts;
        }
        Collection conflictNodes = conflicts;
        DependencyDescriptor[] rootDescriptors = parent.getRoot().getDescriptor().getDependencies();
        for (IvyNode node : conflictNodes) {
            for (DependencyDescriptor dd : rootDescriptors) {
                if (!dd.isForce() || !dd.getDependencyRevisionId().equals(node.getResolvedId())) continue;
                return Collections.singleton(node);
            }
        }
        for (IvyNode node : conflictNodes) {
            DependencyDescriptor dd = node.getDependencyDescriptor(parent);
            if (dd == null || !dd.isForce() || !parent.getResolvedId().equals(dd.getParentRevisionId())) continue;
            return Collections.singleton(node);
        }
        for (IvyNode node : conflictNodes) {
            ModuleRevisionId modRev = node.getResolvedId();
            if (!this.getSettings().getVersionMatcher().isDynamic(modRev)) continue;
            return null;
        }
        Collection results = null;
        try {
            results = super.resolveConflicts(parent, conflicts);
        }
        catch (StrictConflictException e) {
            throw new VerboseConflictException(parent, conflictNodes, e);
        }
        return results;
    }

    private Collection debugResolveConflicts(IvyNode parent, Collection conflicts) {
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        Collection conflictNodes = conflicts;
        IvyNode lastNode = null;
        for (IvyNode node : conflictNodes) {
            if (versionMatcher.isDynamic(node.getResolvedId())) {
                return null;
            }
            if (lastNode != null && !lastNode.equals(node)) {
                throw new DebugConflictException(conflicts, parent, lastNode, node);
            }
            lastNode = node;
        }
        return Collections.singleton(lastNode);
    }
}

