/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.parallel.junit;

import com.netapp.axx.parallel.IOHelper;
import com.netapp.axx.parallel.ParallelAntExecutor;
import com.netapp.axx.parallel.UnitFailureException;
import com.netapp.common.util.ClassUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PropertySet;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class ParallelJUnit
extends Task {
    private static final Pattern PATTERN_RUNNING = Pattern.compile("^.*Running (\\S+)$");
    private static final Pattern PATTERN_EXCEPTION = Pattern.compile("Exception in thread");
    private static final Pattern PATTERN_RESULT = Pattern.compile("^.*Tests run: (\\d+), Failures: (\\d+), Errors: (\\d+), (?:Skipped: (\\d+), )?Time elapsed: (.*)$");
    private final ParallelAntExecutor<Batch> parallelAntExecutor;
    private List<FileSet> buildFileSets = new ArrayList<FileSet>();
    private File reportsDir;
    private int minFilesPerBatch = 10;
    private String failureProperty;
    private boolean haltOnFailure;
    private List<Pattern> standaloneTestPatterns = new ArrayList<Pattern>();

    public ParallelJUnit() {
        this.parallelAntExecutor = new ParallelAntExecutor();
        this.parallelAntExecutor.setUnitTypeName("BATCH");
        this.parallelAntExecutor.setRepeatFirstFailure(false);
        this.parallelAntExecutor.setVerbose(ParallelAntExecutor.VerbosityLevel.NONE.name());
        this.setMaxThreads(5);
    }

    public void addFileset(FileSet buildFiles) {
        this.buildFileSets.add(buildFiles);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.parallelAntExecutor.addPropertyset(propertySet);
    }

    public void addProperty(Property property) {
        this.parallelAntExecutor.addProperty(property);
    }

    public String getTarget() {
        return this.parallelAntExecutor.getTarget();
    }

    public void setTarget(String target) {
        this.parallelAntExecutor.setTarget(target);
    }

    public void setKeepLogs(boolean keepLogs) {
        this.parallelAntExecutor.setKeepLogs(keepLogs);
    }

    public void setRehostCommandPath(String rehostCommandPath) {
        this.parallelAntExecutor.setRehostCommandPath(rehostCommandPath);
    }

    public void setHostPattern(String hostPattern) {
        this.parallelAntExecutor.setHostPattern(hostPattern);
    }

    public void setMinFilesPerBatch(int minFilesPerBatch) {
        this.minFilesPerBatch = minFilesPerBatch;
    }

    public final void setMaxThreads(int maxThreads) {
        this.parallelAntExecutor.setMaxThreads(maxThreads);
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public void setRepeatFirstFailure(boolean repeatFirstFailure) {
        this.parallelAntExecutor.setRepeatFirstFailure(repeatFirstFailure);
    }

    public void setRunLocally(boolean runLocally) {
        this.parallelAntExecutor.setRunLocally(runLocally);
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void setStandaloneTests(String standaloneTests) {
        this.standaloneTestPatterns.clear();
        for (String standAloneTestRegex : standaloneTests.split(",")) {
            if (standAloneTestRegex.trim().isEmpty()) continue;
            this.standaloneTestPatterns.add(Pattern.compile(standAloneTestRegex));
        }
    }

    @Override
    public void setProject(Project project) {
        super.setProject(project);
        this.parallelAntExecutor.setProject(project);
    }

    @Override
    public void execute() {
        if (this.buildFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        List<Batch> batches = this.buildBatches();
        TestResultGatherer testResultGatherer = new TestResultGatherer();
        int testCount = this.getTestCount(batches);
        this.getProject().log(String.format("%n          Tests:  %3d%n        Batches:  %3d%n        Threads:  %3d%n           Host: %s%n%n", testCount, batches.size(), this.parallelAntExecutor.getActualMaxThreads(batches), this.parallelAntExecutor.isRunLocally() ? "local" : "remote"));
        this.printTestTableHeader();
        try {
            this.parallelAntExecutor.execute(batches, testResultGatherer);
            this.printTestTableFooter(testResultGatherer.getTotalRun(), testResultGatherer.getTotalFailures(), testResultGatherer.getTotalErrors(), testResultGatherer.getTotalSkips());
        }
        catch (UnitFailureException e) {
            this.printTestTableFooter(testResultGatherer.getTotalRun(), testResultGatherer.getTotalFailures(), testResultGatherer.getTotalErrors(), testResultGatherer.getTotalSkips());
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            }
            Formatter errorMessage = new Formatter(new StringBuilder());
            if (!testResultGatherer.getBatchesWithExceptions().isEmpty()) {
                errorMessage.format("%d batch(es) had an unexpected exception.%n%n", testResultGatherer.getBatchesWithExceptions().size());
                if (this.printBatchExceptions(testResultGatherer.getBatchesWithExceptions())) {
                    errorMessage.format("The output of the first batch to fail has been displayed.%n%n", new Object[0]);
                }
            }
            if (!testResultGatherer.getTestResultsWithFailuresOrErrors().isEmpty()) {
                errorMessage.format("%d unit test(s) had failures or errors.%n%n", testResultGatherer.getTestResultsWithFailuresOrErrors().size());
                if (this.printFailuresAndErrors(testResultGatherer.getTestResultsWithFailuresOrErrors())) {
                    errorMessage.format("The output of the first unit test to fail has been displayed.", new Object[0]);
                }
            }
            if (this.haltOnFailure) {
                throw new UnitFailureException(errorMessage.out().toString(), e);
            }
            this.getProject().log(errorMessage.out().toString(), 0);
        }
    }

    private int getTestCount(List<Batch> batches) {
        int testCount = 0;
        for (Batch batch : batches) {
            testCount += batch.getTestFileNames().size();
        }
        return testCount;
    }

    private void printTestTableHeader() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        printWriter.println("=====================================================================================");
        printWriter.println(String.format("%-56s%3s%5s%4s%5s%12s", "TEST", "RUN", "FAIL", "ERR", "SKIP", "DURATION"));
        this.getProject().log(stringWriter.toString(), 2);
    }

    private void printTestResult(TestResult testResult) {
        this.getProject().log(String.format("%-56s%3d%5s%4s%5s%12s", ClassUtils.extractUnqualifiedClassName((String)testResult.testName), testResult.testsRun, testResult.failures == 0 ? "" : Integer.valueOf(testResult.failures), testResult.errors == 0 ? "" : Integer.valueOf(testResult.errors), testResult.skips == 0 ? "" : Integer.valueOf(testResult.skips), testResult.elapsedTime), 2);
    }

    private void printTestTableFooter(int totalRun, int totalFailures, int totalErrors, int totalSkips) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("-------------------------------------------------------------------------------------");
        printWriter.println(String.format("%-56s%3d%5s%4s%5s", "TOTAL", totalRun, totalFailures == 0 ? "" : Integer.valueOf(totalFailures), totalErrors == 0 ? "" : Integer.valueOf(totalErrors), totalSkips == 0 ? "" : Integer.valueOf(totalSkips)));
        printWriter.println("=====================================================================================");
        this.getProject().log(stringWriter.toString(), 2);
    }

    private boolean printBatchExceptions(Set<Batch> batchesWithExceptions) {
        if (!batchesWithExceptions.isEmpty()) {
            ArrayList<File> batchOutputFiles = new ArrayList<File>();
            this.getProject().log("The following batches had exceptions:", 2);
            for (Batch batchWithException : batchesWithExceptions) {
                this.getProject().log(batchWithException.getName(), 2);
                if (!batchWithException.getOutputFile().exists()) continue;
                batchOutputFiles.add(batchWithException.getOutputFile());
            }
            if (!batchOutputFiles.isEmpty()) {
                this.getProject().log("\nThe batch exceptions can be seen in the following files:", 2);
                for (File batchOutputFile : batchOutputFiles) {
                    this.getProject().log(batchOutputFile.getAbsolutePath(), 2);
                }
                this.getProject().log("\nResults of first failed batch:", 2);
                IOHelper.readFile((File)batchOutputFiles.get(0), new IOHelper.ProjectLoggerCallback(this.getProject(), 2));
                return true;
            }
        }
        return false;
    }

    private boolean printFailuresAndErrors(List<TestResult> resultsWithFailuresOrErrors) {
        if (!resultsWithFailuresOrErrors.isEmpty()) {
            ArrayList<File> plainReportFiles = new ArrayList<File>();
            this.getProject().log("The following tests had failures or errors:", 2);
            for (TestResult resultWithFailuresOrErrors : resultsWithFailuresOrErrors) {
                File plainReport;
                this.getProject().log(resultWithFailuresOrErrors.testName, 2);
                if (this.reportsDir == null || !(plainReport = new File(this.reportsDir, "TEST-" + resultWithFailuresOrErrors.testName + ".txt")).exists()) continue;
                plainReportFiles.add(plainReport);
            }
            if (!plainReportFiles.isEmpty()) {
                this.getProject().log("\nThe failures and errors can be seen in the following files:", 2);
                for (File plainReportFile : plainReportFiles) {
                    this.getProject().log(plainReportFile.getAbsolutePath(), 2);
                }
                this.getProject().log("\nResults of first failed test:", 2);
                IOHelper.readFile((File)plainReportFiles.get(0), new IOHelper.ProjectLoggerCallback(this.getProject(), 2));
                return true;
            }
        }
        return false;
    }

    private List<Batch> buildBatches() {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        for (FileSet fs : this.buildFileSets) {
            int[] batchSizes;
            int numberOfBatches;
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            ArrayList<String> includedFiles = new ArrayList<String>(Arrays.asList(scanner.getIncludedFiles()));
            Iterator iter = includedFiles.iterator();
            block1: while (iter.hasNext()) {
                String includedFile = (String)iter.next();
                for (Pattern standaloneTestPattern : this.standaloneTestPatterns) {
                    if (!standaloneTestPattern.matcher(includedFile).find()) continue;
                    batches.add(new Batch(String.format("B%02d[%02d-%02d]", batches.size(), batches.size(), batches.size()), Collections.singletonList(includedFile), this.isGwtFileSet(fs)));
                    iter.remove();
                    continue block1;
                }
            }
            int standaloneBatches = batches.size();
            if (includedFiles.isEmpty()) continue;
            int n = numberOfBatches = this.isGwtFileSet(fs) ? 1 : includedFiles.size() / this.minFilesPerBatch;
            if (numberOfBatches == 0) {
                batchSizes = new int[]{includedFiles.size()};
            } else {
                batchSizes = new int[numberOfBatches];
                Arrays.fill(batchSizes, includedFiles.size() / numberOfBatches);
                int batchIndex = 0;
                for (int remainder = includedFiles.size() % numberOfBatches; remainder > 0; --remainder) {
                    int n2 = batchIndex;
                    batchSizes[n2] = batchSizes[n2] + 1;
                    batchIndex = (batchIndex + 1) % numberOfBatches;
                }
            }
            int currentFileIndex = 0;
            for (int batchSize : batchSizes) {
                int endFileIndex = currentFileIndex + batchSize;
                batches.add(new Batch(String.format("B%02d[%02d-%02d]", batches.size(), standaloneBatches + currentFileIndex, standaloneBatches + endFileIndex - 1), includedFiles.subList(currentFileIndex, endFileIndex), this.isGwtFileSet(fs)));
                currentFileIndex = endFileIndex;
            }
        }
        return batches;
    }

    private boolean isGwtFileSet(FileSet fs) {
        return "gwt".equals(fs.getDescription());
    }

    private static class TestResult {
        private final String testName;
        private int testsRun;
        private int failures;
        private int errors;
        private int skips;
        private String elapsedTime;

        private TestResult(String testName) {
            this.testName = testName;
        }

        public void recordResult(int testsRun, int failures, int errors, int skips, String elapsedTime) {
            this.testsRun = testsRun;
            this.failures = failures;
            this.errors = errors;
            this.skips = skips;
            this.elapsedTime = elapsedTime;
        }
    }

    private class TestResultGatherer
    implements ParallelAntExecutor.UnitLineCallback<Batch> {
        private int totalRun;
        private int totalFailures;
        private int totalErrors;
        private int totalSkips;
        private final Map<Batch, List<TestResult>> testResults = new HashMap<Batch, List<TestResult>>();
        private final List<TestResult> testResultsWithFailuresOrErrors = new ArrayList<TestResult>();
        private final Set<Batch> batchesWithExceptions = new HashSet<Batch>();

        private TestResultGatherer() {
        }

        @Override
        public synchronized void processLine(Batch batch, String line) {
            Matcher exceptionMatcher;
            ParallelJUnit.this.getProject().log(batch.name + " " + line, 4);
            List<TestResult> testResultsForUnit = this.testResults.get(batch);
            Matcher runningMatcher = PATTERN_RUNNING.matcher(line);
            if (runningMatcher.find()) {
                if (testResultsForUnit == null) {
                    testResultsForUnit = new ArrayList<TestResult>();
                    this.testResults.put(batch, testResultsForUnit);
                }
                testResultsForUnit.add(new TestResult(runningMatcher.group(1)));
                return;
            }
            Matcher resultMatcher = PATTERN_RESULT.matcher(line);
            if (resultMatcher.find()) {
                TestResult lastResult = testResultsForUnit.get(testResultsForUnit.size() - 1);
                lastResult.recordResult(Integer.parseInt(resultMatcher.group(1)), Integer.parseInt(resultMatcher.group(2)), Integer.parseInt(resultMatcher.group(3)), resultMatcher.group(4) == null ? 0 : Integer.parseInt(resultMatcher.group(4)), resultMatcher.group(5));
                this.totalRun += lastResult.testsRun;
                this.totalFailures += lastResult.failures;
                this.totalErrors += lastResult.errors;
                this.totalSkips += lastResult.skips;
                if (lastResult.failures > 0 || lastResult.errors > 0) {
                    this.testResultsWithFailuresOrErrors.add(lastResult);
                }
                ParallelJUnit.this.printTestResult(lastResult);
            }
            if ((exceptionMatcher = PATTERN_EXCEPTION.matcher(line)).find()) {
                this.batchesWithExceptions.add(batch);
                return;
            }
        }

        public synchronized int getTotalRun() {
            return this.totalRun;
        }

        public synchronized int getTotalFailures() {
            return this.totalFailures;
        }

        public synchronized int getTotalErrors() {
            return this.totalErrors;
        }

        public synchronized int getTotalSkips() {
            return this.totalSkips;
        }

        public synchronized List<TestResult> getTestResultsWithFailuresOrErrors() {
            return this.testResultsWithFailuresOrErrors;
        }

        public Set<Batch> getBatchesWithExceptions() {
            return this.batchesWithExceptions;
        }
    }

    private class Batch
    implements ParallelAntExecutor.Unit {
        private final String name;
        private final List<String> testFileNames;
        private final boolean gwt;

        Batch(String name, List<String> testFileNames, boolean gwt) {
            this.name = name;
            this.testFileNames = testFileNames;
            this.gwt = gwt;
        }

        public List<String> getTestFileNames() {
            return this.testFileNames;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getAdditionalAntProperties() {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("batch.name", this.getName());
            properties.put("test.gwtBatch", Boolean.toString(this.gwt));
            File testIncludeFile = new File(ParallelJUnit.this.reportsDir, "tests-" + this.getName() + ".properties");
            properties.put("test.include.file", testIncludeFile.getAbsolutePath());
            Properties testFilesProperties = new Properties();
            testFilesProperties.put("test.files", ParallelAntExecutor.join(this.getTestFileNames(), ","));
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(testIncludeFile);
                testFilesProperties.store(fileWriter, "Tests included in batch " + this.getName());
            }
            catch (IOException e) {
                throw new BuildException("Error writing testIncludeFile at " + testIncludeFile, e);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {}
                }
            }
            return properties;
        }

        @Override
        public File getProcessWorkingDirectory() {
            return ParallelJUnit.this.getProject().getBaseDir();
        }

        @Override
        public File getOutputFile() {
            return new File(this.getProcessWorkingDirectory(), String.format("target%sant-%s-%s.log", System.getProperty("file.separator"), ParallelJUnit.this.getTarget(), this.name));
        }

        @Override
        public boolean isReady(Map<String, ParallelAntExecutor.UnitState> unitStates) {
            return true;
        }
    }
}

