/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.symlink;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CreateSymlinks
extends Task {
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private String version = "";
    private String destinationPath;
    private String destinationSubPath = "target/package";

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDestinationSubPath(String destinationSubPath) {
        this.destinationSubPath = destinationSubPath;
    }

    @Override
    public void execute() {
        if (this.fileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        for (FileSet fileSet : this.fileSets) {
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            for (String sourceFilePath : scanner.getIncludedFiles()) {
                File sourceFile = new File(fileSet.getDir(), sourceFilePath);
                String sourceFileNameWithoutExtension = this.removeExtension(sourceFile.getName());
                sourceFileNameWithoutExtension = this.removeVersion(sourceFileNameWithoutExtension);
                StringBuilder fullDestinationPath = new StringBuilder().append(this.destinationPath).append('/').append(sourceFileNameWithoutExtension);
                if (this.destinationSubPath != null && this.destinationSubPath.length() != 0) {
                    fullDestinationPath.append('/').append(this.destinationSubPath);
                }
                if (!this.exists(sourceFile.getParent(), fullDestinationPath.toString())) continue;
                this.replaceFileWithLink(sourceFile, fullDestinationPath.toString());
            }
        }
    }

    private boolean exists(String relativeToPath, String fullDestinationPath) {
        if (fullDestinationPath.charAt(0) == '/') {
            return new File(fullDestinationPath).exists();
        }
        return new File(relativeToPath, fullDestinationPath).exists();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void replaceFileWithLink(File sourceFile, String destinationPath) {
        try {
            this.log(String.format("Replacing %s with symlink to %s", sourceFile.getCanonicalPath().replace(this.getProject().getBaseDir().getCanonicalPath() + "/", ""), destinationPath), 2);
        }
        catch (IOException e) {
            this.log(String.format("Replacing %s with symlink to %s", sourceFile.getAbsolutePath(), destinationPath), 2);
        }
        sourceFile.delete();
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", destinationPath, sourceFile.getAbsolutePath()});
            process.waitFor();
        }
        catch (IOException e) {
            throw new BuildException(String.format("Exception occurred while creating symlink %s -> %s", sourceFile.getAbsolutePath(), destinationPath), e);
        }
        catch (InterruptedException e) {
            throw new BuildException(String.format("Exception occurred while creating symlink %s -> %s", sourceFile.getAbsolutePath(), destinationPath), e);
        }
    }

    private String removeExtension(String candidateFileName) {
        int extensionStartIndex = candidateFileName.lastIndexOf(46);
        return extensionStartIndex == -1 ? candidateFileName : candidateFileName.substring(0, extensionStartIndex);
    }

    private String removeVersion(String candidateFileName) {
        int versionStartIndex = candidateFileName.lastIndexOf('-' + this.version);
        return versionStartIndex == -1 ? candidateFileName : candidateFileName.substring(0, versionStartIndex);
    }
}

