/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.JarArchive;
import org.jboss.tattletale.core.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveScanner {
    public static Archive scan(File file) {
        return ArchiveScanner.scan(file, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Archive scan(File file, Map<String, SortedSet<String>> gProvides, List<Archive> known, Set<String> blacklisted) {
        JarArchive archive = null;
        ZipFile jarFile = null;
        try {
            JarEntry jarEntry;
            ClassPool classPool = new ClassPool();
            String name = file.getName();
            String filename = file.getCanonicalPath();
            Integer classVersion = null;
            TreeSet<String> requires = new TreeSet<String>();
            TreeMap<String, Long> provides = new TreeMap<String, Long>();
            TreeSet<String> profiles = new TreeSet<String>();
            TreeMap<String, SortedSet<String>> classDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> packageDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> blacklistedDependencies = new TreeMap<String, SortedSet<String>>();
            ArrayList<String> lSign = null;
            jarFile = new JarFile(file);
            Enumeration<JarEntry> e = ((JarFile)jarFile).entries();
            while (e.hasMoreElements()) {
                InputStream is;
                jarEntry = e.nextElement();
                if (jarEntry.getName().endsWith(".class")) {
                    is = null;
                    try {
                        is = ((JarFile)jarFile).getInputStream(jarEntry);
                        CtClass ctClz = classPool.makeClass(is);
                        if (classVersion == null) {
                            classVersion = ctClz.getClassFile2().getMajorVersion();
                        }
                        Long serialVersionUID = null;
                        try {
                            CtField field = ctClz.getField("serialVersionUID");
                            serialVersionUID = (Long)field.getConstantValue();
                        }
                        catch (NotFoundException nfe) {
                            // empty catch block
                        }
                        provides.put(ctClz.getName(), serialVersionUID);
                        int pkgIdx = ctClz.getName().lastIndexOf(".");
                        String pkg = null;
                        if (pkgIdx != -1) {
                            pkg = ctClz.getName().substring(0, pkgIdx);
                        }
                        Collection c = ctClz.getRefClasses();
                        for (String s : c) {
                            TreeSet<String> bld;
                            requires.add(s);
                            TreeSet<String> cd = (TreeSet<String>)classDependencies.get(ctClz.getName());
                            if (cd == null) {
                                cd = new TreeSet<String>();
                            }
                            cd.add(s);
                            classDependencies.put(ctClz.getName(), cd);
                            int rPkgIdx = s.lastIndexOf(".");
                            String rPkg = null;
                            if (rPkgIdx != -1) {
                                rPkg = s.substring(0, rPkgIdx);
                            }
                            boolean include = true;
                            if (known != null) {
                                Iterator<Archive> kit = known.iterator();
                                while (include && kit.hasNext()) {
                                    Archive a = kit.next();
                                    if (!a.doesProvide(s)) continue;
                                    profiles.add(a.getName());
                                    include = false;
                                }
                            }
                            if (pkg != null && rPkg != null && !pkg.equals(rPkg) && include) {
                                TreeSet<String> pd = (TreeSet<String>)packageDependencies.get(pkg);
                                if (pd == null) {
                                    pd = new TreeSet<String>();
                                }
                                pd.add(rPkg);
                                packageDependencies.put(pkg, pd);
                            }
                            if (blacklisted == null) continue;
                            boolean bl = false;
                            Iterator<String> bit = blacklisted.iterator();
                            while (!bl && bit.hasNext()) {
                                String blp = bit.next();
                                if (!s.startsWith(blp)) continue;
                                bl = true;
                            }
                            if (!bl) continue;
                            String key = pkg;
                            if (key == null) {
                                key = "";
                            }
                            if ((bld = (TreeSet<String>)blacklistedDependencies.get(key)) == null) {
                                bld = new TreeSet<String>();
                            }
                            bld.add(rPkg);
                            blacklistedDependencies.put(key, bld);
                        }
                    }
                    catch (Exception ie) {}
                    continue;
                    finally {
                        try {
                            if (is == null) continue;
                            is.close();
                        }
                        catch (IOException ioe) {}
                        continue;
                    }
                }
                if (jarEntry.getName().indexOf("META-INF") == -1 || !jarEntry.getName().endsWith(".SF")) continue;
                is = null;
                try {
                    is = ((JarFile)jarFile).getInputStream(jarEntry);
                    InputStreamReader isr = new InputStreamReader(is);
                    LineNumberReader lnr = new LineNumberReader(isr);
                    if (lSign == null) {
                        lSign = new ArrayList<String>();
                    }
                    String s = lnr.readLine();
                    while (s != null) {
                        lSign.add(s);
                        s = lnr.readLine();
                    }
                }
                catch (Exception ie) {}
                continue;
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (provides.size() == 0) {
                jarEntry = null;
                return jarEntry;
            }
            String version = null;
            List<String> lManifest = null;
            Manifest manifest = ((JarFile)jarFile).getManifest();
            if (manifest != null) {
                Attributes mainAttributes = manifest.getMainAttributes();
                version = mainAttributes.getValue("Specification-Version");
                if (version == null) {
                    version = mainAttributes.getValue("Implementation-Version");
                }
                if (version == null) {
                    version = mainAttributes.getValue("Version");
                }
                if (version == null && manifest.getEntries() != null) {
                    Iterator<Attributes> ait = manifest.getEntries().values().iterator();
                    while (version == null && ait.hasNext()) {
                        Attributes attributes = ait.next();
                        version = attributes.getValue("Specification-Version");
                        if (version == null) {
                            version = attributes.getValue("Implementation-Version");
                        }
                        if (version != null) continue;
                        version = attributes.getValue("Version");
                    }
                }
                lManifest = ArchiveScanner.readManifest(manifest);
            }
            Location location = new Location(filename, version);
            archive = new JarArchive(name, classVersion, lManifest, lSign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location);
            if (profiles.size() > 0) {
                for (String profile : profiles) {
                    archive.addProfile(profile);
                }
            }
            for (String provide : provides.keySet()) {
                if (gProvides != null) {
                    SortedSet<String> ss = gProvides.get(provide);
                    if (ss == null) {
                        ss = new TreeSet<String>();
                    }
                    ss.add(archive.getName());
                    gProvides.put(provide, ss);
                }
                requires.remove(provide);
            }
        }
        catch (IOException ioe) {
        }
        catch (Exception e) {
            System.err.println("Scan: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ioe) {}
        }
        return archive;
    }

    private static List<String> readManifest(Manifest manifest) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            InputStreamReader isr = new InputStreamReader(bais);
            LineNumberReader lnr = new LineNumberReader(isr);
            String s = lnr.readLine();
            while (s != null) {
                result.add(s);
                s = lnr.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

