/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDependantsReport
extends CLSReport {
    private static final String NAME = "Class Dependants";
    private static final String DIRECTORY = "classdependants";

    public ClassDependantsReport(SortedSet<Archive> archives, List<Archive> known, String classloaderStructure) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY, classloaderStructure, known);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Class</th>" + Dump.NEW_LINE);
        bw.write("     <th>Dependants</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        boolean odd = true;
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            SortedMap<String, SortedSet<String>> classDependencies = archive.getClassDependencies();
            for (Map.Entry<String, SortedSet<String>> entry : classDependencies.entrySet()) {
                String clz = entry.getKey();
                SortedSet<String> clzDeps = entry.getValue();
                for (String dep : clzDeps) {
                    if (dep.equals(clz)) continue;
                    boolean include = true;
                    Iterator<Archive> kit = this.getKnown().iterator();
                    while (include && kit.hasNext()) {
                        Archive a = kit.next();
                        if (!a.doesProvide(dep)) continue;
                        include = false;
                    }
                    if (!include) continue;
                    TreeSet<String> deps = (TreeSet<String>)result.get(dep);
                    if (deps == null) {
                        deps = new TreeSet<String>();
                    }
                    deps.add(clz);
                    result.put(dep, deps);
                }
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            String clz = (String)entry.getKey();
            SortedSet deps = (SortedSet)entry.getValue();
            if (deps == null || deps.size() <= 0) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td>" + clz + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            Iterator sit = deps.iterator();
            while (sit.hasNext()) {
                String dep = (String)sit.next();
                bw.write(dep);
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Class Dependants</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

