/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLocationReport
extends Report {
    private static final String NAME = "Class Location";
    private static final String DIRECTORY = "classlocation";
    private SortedMap<String, SortedSet<String>> gProvides;

    public ClassLocationReport(SortedSet<Archive> archives, SortedMap<String, SortedSet<String>> gProvides) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY);
        this.gProvides = gProvides;
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Class</th>" + Dump.NEW_LINE);
        bw.write("     <th>Jar files</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        for (Map.Entry<String, SortedSet<String>> entry : this.gProvides.entrySet()) {
            String clz = entry.getKey();
            SortedSet<String> archives = entry.getValue();
            boolean filtered = this.isFiltered(clz);
            if (!filtered && archives.size() > 1) {
                this.status = 1;
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td>" + clz + "</td>" + Dump.NEW_LINE);
            if (!filtered) {
                bw.write("        <td>");
            } else {
                bw.write("        <td style=\"text-decoration: line-through;\">");
            }
            Iterator sit = archives.iterator();
            while (sit.hasNext()) {
                String archive = (String)sit.next();
                bw.write("<a href=\"../jar/" + archive + ".html\">" + archive + "</a>" + Dump.NEW_LINE);
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Class Location</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

