/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizReport
extends CLSReport {
    private static final String NAME = "Graphical dependencies";
    private static final String DIRECTORY = "graphviz";
    private boolean enableDot = true;
    private String graphvizDot = "dot";

    public GraphvizReport(SortedSet<Archive> archives, List<Archive> known, String classloaderStructure, Properties config) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY, classloaderStructure, known);
        if (config != null) {
            this.enableDot = Boolean.valueOf(config.getProperty("enableDot", "true"));
            this.graphvizDot = config.getProperty("graphvizDot", "dot");
        }
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Archives</th>" + Dump.NEW_LINE);
        bw.write("     <th>Packages</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean hasDot = this.testDot();
        boolean odd = true;
        FileWriter alldotfw = new FileWriter(this.getOutputDir().getAbsolutePath() + File.separator + "dependencies.dot");
        BufferedWriter alldotw = new BufferedWriter(alldotfw, 8192);
        alldotw.write("digraph dependencies {" + Dump.NEW_LINE);
        alldotw.write("  node [shape = box, fontsize=10.0];" + Dump.NEW_LINE);
        for (Archive archive : this.archives) {
            BufferedWriter dotw;
            FileWriter dotfw;
            String dotName;
            File doutput;
            if (archive.getType() != 0) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            TreeSet<String> result = new TreeSet<String>();
            for (String require : archive.getRequires()) {
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (!a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
            }
            if (result.size() == 0) {
                bw.write("&nbsp;");
            } else {
                bw.write("<a href=\"" + archive.getName() + "/" + archive.getName() + ".dot\">.dot</a>");
                if (hasDot) {
                    bw.write("&nbsp;");
                    bw.write("<a href=\"" + archive.getName() + "/" + archive.getName() + ".png\">.png</a>");
                }
                doutput = new File(this.getOutputDir(), archive.getName());
                doutput.mkdirs();
                dotName = doutput.getAbsolutePath() + File.separator + archive.getName() + ".dot";
                String pngName = doutput.getAbsolutePath() + File.separator + archive.getName() + ".png";
                dotfw = new FileWriter(dotName);
                dotw = new BufferedWriter(dotfw, 8192);
                dotw.write("digraph " + this.dotName(archive.getName()) + "_dependencies {" + Dump.NEW_LINE);
                dotw.write("  node [shape = box, fontsize=10.0];" + Dump.NEW_LINE);
                for (String string : result) {
                    alldotw.write("  " + this.dotName(archive.getName()) + " -> " + this.dotName(string) + ";" + Dump.NEW_LINE);
                    dotw.write("  " + this.dotName(archive.getName()) + " -> " + this.dotName(string) + ";" + Dump.NEW_LINE);
                }
                dotw.write("}" + Dump.NEW_LINE);
                dotw.flush();
                dotw.close();
                if (this.enableDot && hasDot) {
                    this.generatePicture(dotName, pngName, doutput);
                }
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            if (archive.getPackageDependencies().size() == 0) {
                bw.write("&nbsp;");
            } else {
                bw.write("<a href=\"" + archive.getName() + "/" + archive.getName() + "-package.dot\">.dot</a>");
                if (hasDot) {
                    bw.write("&nbsp;");
                    bw.write("<a href=\"" + archive.getName() + "/" + archive.getName() + "-package.png\">.png</a>");
                }
                doutput = new File(this.getOutputDir(), archive.getName());
                doutput.mkdirs();
                dotName = doutput.getAbsolutePath() + File.separator + archive.getName() + "-package.dot";
                String pngName = doutput.getAbsolutePath() + File.separator + archive.getName() + "-package.png";
                dotfw = new FileWriter(dotName);
                dotw = new BufferedWriter(dotfw, 8192);
                dotw.write("digraph " + this.dotName(archive.getName()) + "_package_dependencies {" + Dump.NEW_LINE);
                dotw.write("  node [shape = box, fontsize=10.0];" + Dump.NEW_LINE);
                for (Map.Entry entry : archive.getPackageDependencies().entrySet()) {
                    String pkg = this.dotName((String)entry.getKey());
                    SortedSet deps = (SortedSet)entry.getValue();
                    for (String dep : deps) {
                        dotw.write("  " + pkg + " -> " + this.dotName(dep) + ";" + Dump.NEW_LINE);
                    }
                }
                dotw.write("}" + Dump.NEW_LINE);
                dotw.flush();
                dotw.close();
                if (this.enableDot && hasDot) {
                    this.generatePicture(dotName, pngName, doutput);
                }
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        alldotw.write("}" + Dump.NEW_LINE);
        alldotw.flush();
        alldotw.close();
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Graphical dependencies</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
        bw.write("<a href=\"dependencies.dot\">All dependencies</a>");
        bw.write("<p>" + Dump.NEW_LINE);
    }

    private String dotName(String name) {
        int idx = name.indexOf(".jar");
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name.replace('-', '_').replace('.', '_');
    }

    private boolean testDot() {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb = pb.command(this.graphvizDot, "-V");
            Process proc = pb.redirectErrorStream(true).start();
            proc.waitFor();
            return proc.exitValue() == 0;
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean generatePicture(String dotName, String pngName, File directory) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb = pb.command(this.graphvizDot, "-Tpng", dotName, "-o", pngName);
            pb = pb.directory(directory);
            Process proc = pb.redirectErrorStream(true).start();
            BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            proc.waitFor();
            return proc.exitValue() == 0;
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        return false;
    }
}

