/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoVersionReport
extends Report {
    private static final String NAME = "No version";
    private static final String DIRECTORY = "noversion";

    public NoVersionReport(SortedSet<Archive> archives) {
        super(DIRECTORY, 2, archives, NAME, DIRECTORY);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Name</th>" + Dump.NEW_LINE);
        bw.write("     <th>Location</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            SortedSet<Location> locations = archive.getLocations();
            Iterator lit = locations.iterator();
            Location location2 = (Location)lit.next();
            boolean include = false;
            boolean filtered = this.isFiltered(archive.getName());
            while (!include && lit.hasNext()) {
                location2 = (Location)lit.next();
                if (location2.getVersion() != null) continue;
                include = true;
                if (filtered) continue;
                this.status = 2;
            }
            if (!include) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            bw.write("       <table>" + Dump.NEW_LINE);
            for (Location location2 : locations) {
                bw.write("      <tr>" + Dump.NEW_LINE);
                bw.write("        <td>" + location2.getFilename() + "</td>" + Dump.NEW_LINE);
                if (!filtered) {
                    bw.write("        <td>");
                } else {
                    bw.write("        <td style=\"text-decoration: line-through;\">");
                }
                if (location2.getVersion() != null) {
                    bw.write(location2.getVersion());
                } else {
                    bw.write("<i>Not listed</i>");
                }
                bw.write("</td>" + Dump.NEW_LINE);
                bw.write("      </tr>" + Dump.NEW_LINE);
            }
            bw.write("       </table>" + Dump.NEW_LINE);
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>No version</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

