/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyValueFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Report
implements Comparable {
    private String id;
    protected int severity;
    protected int status;
    protected SortedSet<Archive> archives;
    private String name = null;
    private String directory = null;
    private File outputDir;
    private String filter;
    private Filter filterImpl;
    private static final String INDEX_HTML = "index.html";

    public Report(String id, int severity, SortedSet<Archive> archives) {
        this.id = id;
        this.severity = severity;
        this.archives = archives;
        this.status = 0;
        this.filter = null;
        this.filterImpl = null;
    }

    public Report(String id, int severity, SortedSet<Archive> archives, String name, String directory) {
        this(id, severity, archives);
        this.name = name;
        this.directory = directory;
    }

    public String getId() {
        return this.id;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.name;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.filterImpl = this.createFilter();
        this.filterImpl.init(filter);
    }

    File getOutputDir() {
        return this.outputDir;
    }

    public void generate(String outputDirectory) {
        try {
            this.createOutputDir(outputDirectory);
            BufferedWriter bw = this.getBufferedWriter();
            this.writeHtmlHead(bw);
            this.writeHtmlBodyHeader(bw);
            this.writeHtmlBodyContent(bw);
            this.writeHtmlBodyFooter(bw);
            this.writeHtmlFooter(bw);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.err.println(this.getName() + " Report: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    void createOutputDir(String outputDirectory) {
        this.outputDir = new File(outputDirectory, this.getDirectory());
        this.outputDir.mkdirs();
    }

    BufferedWriter getBufferedWriter() throws IOException {
        return this.getBufferedWriter(INDEX_HTML);
    }

    BufferedWriter getBufferedWriter(String filename) throws IOException {
        FileWriter fw = new FileWriter(this.getOutputDir().getAbsolutePath() + File.separator + filename);
        return new BufferedWriter(fw, 8192);
    }

    void writeHtmlHead(BufferedWriter bw) throws IOException {
        bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.NEW_LINE);
        bw.write("<html>" + Dump.NEW_LINE);
        bw.write("<head>" + Dump.NEW_LINE);
        bw.write("  <title>JBoss Tattletale 1.1.2.Final: " + this.getName() + "</title>" + Dump.NEW_LINE);
        bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.NEW_LINE);
        bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"../style.css\">" + Dump.NEW_LINE);
        bw.write("</head>" + Dump.NEW_LINE);
    }

    abstract void writeHtmlBodyHeader(BufferedWriter var1) throws IOException;

    abstract void writeHtmlBodyContent(BufferedWriter var1) throws IOException;

    void writeHtmlBodyFooter(BufferedWriter bw) throws IOException {
        bw.write(Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
        bw.write("<hr>" + Dump.NEW_LINE);
        bw.write("Generated by: <a href=\"http://www.jboss.org/projects/tattletale\">JBoss Tattletale 1.1.2.Final</a>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("</body>" + Dump.NEW_LINE);
    }

    void writeHtmlFooter(BufferedWriter bw) throws IOException {
        bw.write("</html>" + Dump.NEW_LINE);
    }

    public int compareTo(Object o) {
        Report r = (Report)o;
        if (this.severity == r.getSeverity()) {
            return this.getName().compareTo(r.getName());
        }
        if (this.severity < r.getSeverity()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Report)) {
            return false;
        }
        Report r = (Report)obj;
        return this.getName().equals(r.getName());
    }

    public int hashCode() {
        return 7 + 31 * this.getName().hashCode();
    }

    protected Filter createFilter() {
        return new KeyValueFilter();
    }

    protected boolean isFiltered() {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered();
        }
        return false;
    }

    protected boolean isFiltered(String archive) {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered(archive);
        }
        return false;
    }

    protected boolean isFiltered(String archive, String query) {
        if (this.filterImpl != null) {
            return this.filterImpl.isFiltered(archive, query);
        }
        return false;
    }
}

