/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting.profiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.profiles.CDI10;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonProfile
extends NestableArchive {
    protected SortedSet<String> classSet = new TreeSet<String>();

    public CommonProfile(String classSet, int type, String name, int version, String location) {
        super(type, name, version, null, null, null, null, null, null, null, null);
        this.loadClassList(classSet);
        this.addLocation(new Location(location, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadClassList(String resourceFile) {
        InputStream is = null;
        try {
            is = CDI10.class.getClassLoader().getResourceAsStream(resourceFile);
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            while (s != null) {
                this.classSet.add(s);
                s = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public boolean included(boolean allProfiles, Set<String> profileSet) {
        return allProfiles || profileSet != null && (profileSet.contains(this.getProfileCode()) || profileSet.contains(this.getProfileName()));
    }

    public abstract String getProfileCode();

    protected abstract String getProfileName();

    @Override
    public boolean doesProvide(String clz) {
        return this.classSet.contains(clz);
    }
}

