/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.platform.passwordmanager;

import com.netapp.platform.keystoremanager.KeystoreManager;

public class PasswordManager {
    private static String JBOSS_DB_USER_PASSWD_KEY = "JBOSS_DB_USER_PASSWD_KEY";
    private KeystoreManager keystoreManager = null;

    public PasswordManager(String keyStoreDir) throws Exception {
        this.keystoreManager = new KeystoreManager(keyStoreDir);
    }

    private static boolean checkSyntax(String[] args) {
        if (args.length < 2 && args.length > 3) {
            return false;
        }
        if (!args[1].equalsIgnoreCase("retrieveJBossPassword") && !args[1].equalsIgnoreCase("changeJBossPassword")) {
            return false;
        }
        return !args[1].equalsIgnoreCase("changeJBossPassword") || args.length != 2;
    }

    private static void printUsage() {
        System.err.println("Usage : <Full path of keystore dir> retrieveJBossPassword");
        System.err.println("        <Full path of keystore dir> changeJBossPassword <New Password>");
    }

    public String retrieveJBossPassword() throws Exception {
        return "";
    }

    public void changeJBossPassword(String newPassword) throws Exception {
        this.keystoreManager.set(JBOSS_DB_USER_PASSWD_KEY, newPassword);
    }

    public static void main(String[] args) throws Exception {
        if (!PasswordManager.checkSyntax(args)) {
            PasswordManager.printUsage();
            System.exit(1);
        }
        PasswordManager passwordManager = new PasswordManager(args[0]);
        if (args[1].equalsIgnoreCase("retrieveJBossPassword")) {
            System.out.println(passwordManager.retrieveJBossPassword());
        } else if (args[1].equalsIgnoreCase("changeJBossPassword")) {
            passwordManager.changeJBossPassword(args[2]);
        }
    }
}

