/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.codecenter.client.util;

import com.blackducksoftware.sdk.codecenter.application.ApplicationApi;
import com.blackducksoftware.sdk.codecenter.approval.ApprovalApi;
import com.blackducksoftware.sdk.codecenter.attribute.AttributeApi;
import com.blackducksoftware.sdk.codecenter.client.util.ProgrammedPasswordCallback;
import com.blackducksoftware.sdk.codecenter.cola.ColaApi;
import com.blackducksoftware.sdk.codecenter.deeplicense.DeepLicenseDataApi;
import com.blackducksoftware.sdk.codecenter.externalid.ExternalIdApi;
import com.blackducksoftware.sdk.codecenter.report.ReportApi;
import com.blackducksoftware.sdk.codecenter.request.RequestApi;
import com.blackducksoftware.sdk.codecenter.role.RoleApi;
import com.blackducksoftware.sdk.codecenter.settings.SettingsApi;
import com.blackducksoftware.sdk.codecenter.user.UserApi;
import com.blackducksoftware.sdk.codecenter.vulnerability.VulnerabilityApi;
import com.blackducksoftware.sdk.codecenter.workflow.WorkflowApi;
import com.blackducksoftware.sdk.impl.logging.PrettyLoggingInInterceptor;
import com.blackducksoftware.sdk.impl.logging.PrettyLoggingOutInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEPasswordMaskedLoggingInInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEPasswordMaskedLoggingOutInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEPasswordMaskedPrettyLoggingInInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEPasswordMaskedPrettyLoggingOutInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEStrippedLoggingInInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEStrippedLoggingOutInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEStrippedPrettyLoggingInInterceptor;
import com.blackducksoftware.sdk.impl.logging.WSSEStrippedPrettyLoggingOutInterceptor;
import com.blackducksoftware.sdk.impl.logging.WsseLoggingLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;

public class CodeCenterServerProxyV7_0 {
    public static final Long INDEFINITE_TIMEOUT = 0L;
    public static final String CODECENTER_SDK_DEBUG_PROPERTY = "codecenter.sdk.debug";
    public static final String CODECENTER_SDK_PROXY_HOST_PROPERTY = "codecenter.sdk.proxy.hostname";
    public static final String CODECENTER_SDK_PROXY_PORT_PROPERTY = "codecenter.sdk.proxy.port";
    public static final String CODECENTER_SDK_PROXY_TYPE_PROPERTY = "codecenter.sdk.proxy.type";
    private static final String CODECENTER_SDK_BASE_URI = "/codecenter-sdk";
    private static final String CODECENTER_SDK_VERSION = "/v7_0";
    private static final String COLA_API_SERVICE_STUB = "/codecenter-sdk/v7_0/cola";
    private static final String VULNERABILITY_API_SERVICE_STUB = "/codecenter-sdk/v7_0/vulnerability";
    private static final String USER_API_SERVICE_STUB = "/codecenter-sdk/v7_0/user";
    private static final String ATTRIBUTE_API_SERVICE_STUB = "/codecenter-sdk/v7_0/attribute";
    private static final String APPROVAL_API_SERVICE_STUB = "/codecenter-sdk/v7_0/approval";
    private static final String APPLICATION_API_SERVICE_STUB = "/codecenter-sdk/v7_0/application";
    private static final String REQUEST_API_SERVICE_STUB = "/codecenter-sdk/v7_0/request";
    private static final String ROLE_API_SERVICE_STUB = "/codecenter-sdk/v7_0/role";
    private static final String EXTERNAL_ID_API_SERVICE_STUB = "/codecenter-sdk/v7_0/externalId";
    private static final String SETTINGS_API_SERVICE_STUB = "/codecenter-sdk/v7_0/settings";
    private static final String WORKFLOW_API_SERVICE_STUB = "/codecenter-sdk/v7_0/workflow";
    private static final String DEEPLICENSEDATA_API_SERVICE_STUB = "/codecenter-sdk/v7_0/deeplicense";
    private static final String REPORT_API_SERVICE_STUB = "/codecenter-sdk/v7_0/report";
    protected WsseLoggingLevel wsseLoggingLevel = WsseLoggingLevel.COMPACT_PRETTY;
    protected Map<String, Object> inProps = null;
    protected Map<String, Object> outProps = null;
    protected boolean logDebug = false;
    protected String serverUrl = null;
    private String userName = null;
    private String password = null;
    protected Long defaultTimeout = INDEFINITE_TIMEOUT;
    private String proxyServer = null;
    private int proxyPort = -1;
    private ProxyServerType proxyType = null;
    private ColaApi colaApi = null;
    private VulnerabilityApi vulnerabilityApi = null;
    private UserApi userApi = null;
    private AttributeApi attributeApi = null;
    private ApprovalApi approvalApi = null;
    private ApplicationApi applicationApi = null;
    private RequestApi requestApi = null;
    private RoleApi roleApi = null;
    private ExternalIdApi externalIdApi = null;
    private SettingsApi settingsApi = null;
    private WorkflowApi workflowApi = null;
    private DeepLicenseDataApi deepLicenseDataApi = null;
    private ReportApi reportApi = null;

    public CodeCenterServerProxyV7_0(String string, String string2, String string3) {
        String string4;
        while (string.length() > 0 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        String string5 = System.getProperty(CODECENTER_SDK_DEBUG_PROPERTY, "false");
        if (string5.equals(WsseLoggingLevel.COMPACT_PRETTY.getExternalLevel()) || string5.equals("true")) {
            this.logDebug = true;
            this.wsseLoggingLevel = WsseLoggingLevel.COMPACT_PRETTY;
        } else if (string5.equals(WsseLoggingLevel.COMPACT.getExternalLevel()) || string5.equals(WsseLoggingLevel.VERBOSE_SECURE.getExternalLevel()) || string5.equals(WsseLoggingLevel.VERBOSE_SECURE_PRETTY.getExternalLevel()) || string5.equals(WsseLoggingLevel.VERBOSE.getExternalLevel())) {
            this.logDebug = true;
            this.wsseLoggingLevel = WsseLoggingLevel.createFromExternalLevel((String)string5);
        } else if ("false".equals(string5)) {
            this.logDebug = false;
        } else {
            System.err.println("Unknown value for system property 'codecenter.sdk.debug=" + string5 + "'. Expected 0, 1, 2, 3, or 4");
        }
        if (this.logDebug) {
            System.err.println("ServerUrl = " + string);
        }
        if ((string4 = System.getProperty(CODECENTER_SDK_PROXY_HOST_PROPERTY)) != null) {
            String string6 = System.getProperty(CODECENTER_SDK_PROXY_TYPE_PROPERTY, "http");
            String string7 = "8080";
            ProxyServerType proxyServerType = ProxyServerType.HTTP;
            if ("http".equalsIgnoreCase(string6)) {
                proxyServerType = ProxyServerType.HTTP;
                string7 = System.getProperty(CODECENTER_SDK_PROXY_PORT_PROPERTY, "8080");
            } else if ("socks".equalsIgnoreCase(string6)) {
                proxyServerType = ProxyServerType.SOCKS;
                string7 = System.getProperty(CODECENTER_SDK_PROXY_PORT_PROPERTY, "1080");
            } else {
                System.err.println("Unknown proxy type: '" + string6 + "' proxy server disabled.");
            }
            int n = Integer.parseInt(string7);
            this.setProxyServer(string4, n, proxyServerType, false);
        }
        this.serverUrl = string;
        if (this.logDebug) {
            System.err.println("Authenticate with: " + string2 + " :: " + this.getPasswordMask(string3));
        }
        this.userName = string2;
        this.password = string3;
    }

    public CodeCenterServerProxyV7_0(String string, String string2, String string3, Long l) {
        this(string, string2, string3);
        this.setDefaultTimeout(l);
    }

    public Long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(Long l) {
        this.defaultTimeout = l;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ProxyServerType getProxyType() {
        return this.proxyType;
    }

    public void setProxyServer(String string, int n, ProxyServerType proxyServerType, boolean bl) {
        this.proxyServer = string;
        this.proxyPort = n;
        this.proxyType = proxyServerType;
        if (this.logDebug) {
            System.err.println("Using " + this.proxyType + " proxy: " + this.proxyServer + ":" + this.proxyPort);
        }
        if (bl) {
            if (this.applicationApi != null) {
                this.setProxyServer(this.applicationApi, string, n, proxyServerType);
            }
            if (this.approvalApi != null) {
                this.setProxyServer(this.approvalApi, string, n, proxyServerType);
            }
            if (this.attributeApi != null) {
                this.setProxyServer(this.attributeApi, string, n, proxyServerType);
            }
            if (this.colaApi != null) {
                this.setProxyServer(this.colaApi, string, n, proxyServerType);
            }
            if (this.externalIdApi != null) {
                this.setProxyServer(this.externalIdApi, string, n, proxyServerType);
            }
            if (this.requestApi != null) {
                this.setProxyServer(this.requestApi, string, n, proxyServerType);
            }
            if (this.userApi != null) {
                this.setProxyServer(this.userApi, string, n, proxyServerType);
            }
            if (this.vulnerabilityApi != null) {
                this.setProxyServer(this.vulnerabilityApi, string, n, proxyServerType);
            }
        }
    }

    protected void setProxyServer(Object object, String string, int n, ProxyServerType proxyServerType) throws RuntimeException {
        try {
            Client client = ClientProxy.getClient((Object)object);
            HTTPConduit hTTPConduit = (HTTPConduit)client.getConduit();
            if (this.logDebug) {
                System.out.println("set proxy server for service: " + hTTPConduit.getTarget().getAddress().getValue());
            }
            HTTPClientPolicy hTTPClientPolicy = new HTTPClientPolicy();
            hTTPClientPolicy.setProxyServer(string);
            hTTPClientPolicy.setProxyServerPort(n);
            hTTPClientPolicy.setProxyServerType(proxyServerType);
            hTTPConduit.setClient(hTTPClientPolicy);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public ColaApi getColaApi() {
        return this.getColaApi(this.defaultTimeout);
    }

    public ColaApi getColaApi(Long l) {
        if (this.colaApi == null) {
            this.colaApi = (ColaApi)this.getPortFromUrl(ColaApi.class, this.serverUrl + COLA_API_SERVICE_STUB);
            this.instrumentService(this.colaApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.colaApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.colaApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.colaApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.colaApi;
    }

    public VulnerabilityApi getVulnerabilityApi() {
        return this.getVulnerabilityApi(this.defaultTimeout);
    }

    public VulnerabilityApi getVulnerabilityApi(Long l) {
        if (this.vulnerabilityApi == null) {
            this.vulnerabilityApi = (VulnerabilityApi)this.getPortFromUrl(VulnerabilityApi.class, this.serverUrl + VULNERABILITY_API_SERVICE_STUB);
            this.instrumentService(this.vulnerabilityApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.vulnerabilityApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.vulnerabilityApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.vulnerabilityApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.vulnerabilityApi;
    }

    public UserApi getUserApi() {
        return this.getUserApi(this.defaultTimeout);
    }

    public UserApi getUserApi(Long l) {
        if (this.userApi == null) {
            this.userApi = (UserApi)this.getPortFromUrl(UserApi.class, this.serverUrl + USER_API_SERVICE_STUB);
            this.instrumentService(this.userApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.userApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.userApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.userApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.userApi;
    }

    public AttributeApi getAttributeApi() {
        return this.getAttributeApi(this.defaultTimeout);
    }

    public AttributeApi getAttributeApi(Long l) {
        if (this.attributeApi == null) {
            this.attributeApi = (AttributeApi)this.getPortFromUrl(AttributeApi.class, this.serverUrl + ATTRIBUTE_API_SERVICE_STUB);
            this.instrumentService(this.attributeApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.attributeApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.attributeApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.attributeApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.attributeApi;
    }

    public ApprovalApi getApprovalApi() {
        return this.getApprovalApi(this.defaultTimeout);
    }

    public ApprovalApi getApprovalApi(Long l) {
        if (this.approvalApi == null) {
            this.approvalApi = (ApprovalApi)this.getPortFromUrl(ApprovalApi.class, this.serverUrl + APPROVAL_API_SERVICE_STUB);
            this.instrumentService(this.approvalApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.approvalApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.approvalApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.approvalApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.approvalApi;
    }

    public ApplicationApi getApplicationApi() {
        return this.getApplicationApi(this.defaultTimeout);
    }

    public ApplicationApi getApplicationApi(Long l) {
        if (this.applicationApi == null) {
            this.applicationApi = (ApplicationApi)this.getPortFromUrl(ApplicationApi.class, this.serverUrl + APPLICATION_API_SERVICE_STUB);
            this.instrumentService(this.applicationApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.applicationApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.applicationApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.applicationApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.applicationApi;
    }

    public RequestApi getRequestApi() {
        return this.getRequestApi(this.defaultTimeout);
    }

    public RequestApi getRequestApi(Long l) {
        if (this.requestApi == null) {
            this.requestApi = (RequestApi)this.getPortFromUrl(RequestApi.class, this.serverUrl + REQUEST_API_SERVICE_STUB);
            this.instrumentService(this.requestApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.requestApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.requestApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.requestApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.requestApi;
    }

    public RoleApi getRoleApi() {
        return this.getRoleApi(this.defaultTimeout);
    }

    public RoleApi getRoleApi(Long l) {
        if (this.roleApi == null) {
            this.roleApi = (RoleApi)this.getPortFromUrl(RoleApi.class, this.serverUrl + ROLE_API_SERVICE_STUB);
            this.instrumentService(this.roleApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.roleApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.roleApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.roleApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.roleApi;
    }

    public ExternalIdApi getExternalIdApi() {
        return this.getExternalIdApi(this.defaultTimeout);
    }

    public ExternalIdApi getExternalIdApi(Long l) {
        if (this.externalIdApi == null) {
            this.externalIdApi = (ExternalIdApi)this.getPortFromUrl(ExternalIdApi.class, this.serverUrl + EXTERNAL_ID_API_SERVICE_STUB);
            this.instrumentService(this.externalIdApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.externalIdApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.externalIdApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.externalIdApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.externalIdApi;
    }

    protected void initAuthProps(String string, String string2) {
        if (this.inProps == null) {
            this.inProps = new HashMap<String, Object>();
            this.inProps.put("action", "NoSecurity");
        }
        if (this.outProps == null) {
            this.outProps = new HashMap<String, Object>();
            this.outProps.put("action", "UsernameToken");
            this.outProps.put("user", string);
            this.outProps.put("passwordType", "PasswordText");
            this.outProps.put("passwordCallbackClass", ProgrammedPasswordCallback.class.getName());
            this.outProps.put("mustUnderstand", "false");
            ProgrammedPasswordCallback.addUserNameAndPassword(string, string2);
        }
        if (this.logDebug) {
            System.out.println("Authenticate with: " + string + " :: " + this.getPasswordMask(string2));
        }
    }

    protected void instrumentService(Object object, String string, String string2, Long l) {
        Client client = ClientProxy.getClient((Object)object);
        if (this.logDebug) {
            System.out.println("instrument service: " + client.getConduit().getTarget().getAddress().getValue());
        }
        this.initAuthProps(string, string2);
        Endpoint endpoint = client.getEndpoint();
        WSS4JOutInterceptor wSS4JOutInterceptor = new WSS4JOutInterceptor(this.outProps);
        endpoint.getOutInterceptors().add(wSS4JOutInterceptor);
        if (this.logDebug) {
            WSSEStrippedLoggingInInterceptor wSSEStrippedLoggingInInterceptor = null;
            WSSEStrippedLoggingOutInterceptor wSSEStrippedLoggingOutInterceptor = null;
            WSSEStrippedLoggingInInterceptor wSSEStrippedLoggingInInterceptor2 = null;
            if (this.wsseLoggingLevel == WsseLoggingLevel.COMPACT) {
                wSSEStrippedLoggingInInterceptor = new WSSEStrippedLoggingInInterceptor();
                wSSEStrippedLoggingInInterceptor2 = new WSSEStrippedLoggingInInterceptor();
                wSSEStrippedLoggingOutInterceptor = new WSSEStrippedLoggingOutInterceptor();
            } else if (this.wsseLoggingLevel == WsseLoggingLevel.COMPACT_PRETTY) {
                wSSEStrippedLoggingInInterceptor = new WSSEStrippedPrettyLoggingInInterceptor();
                wSSEStrippedLoggingInInterceptor2 = new WSSEStrippedPrettyLoggingInInterceptor();
                wSSEStrippedLoggingOutInterceptor = new WSSEStrippedPrettyLoggingOutInterceptor();
            } else if (this.wsseLoggingLevel == WsseLoggingLevel.VERBOSE) {
                wSSEStrippedLoggingInInterceptor = new PrettyLoggingInInterceptor();
                wSSEStrippedLoggingInInterceptor2 = new PrettyLoggingInInterceptor();
                wSSEStrippedLoggingOutInterceptor = new PrettyLoggingOutInterceptor();
            } else if (this.wsseLoggingLevel == WsseLoggingLevel.VERBOSE_SECURE) {
                wSSEStrippedLoggingInInterceptor = new WSSEPasswordMaskedLoggingInInterceptor();
                wSSEStrippedLoggingInInterceptor2 = new WSSEPasswordMaskedLoggingInInterceptor();
                wSSEStrippedLoggingOutInterceptor = new WSSEPasswordMaskedLoggingOutInterceptor();
            } else if (this.wsseLoggingLevel == WsseLoggingLevel.VERBOSE_SECURE_PRETTY) {
                wSSEStrippedLoggingInInterceptor = new WSSEPasswordMaskedPrettyLoggingInInterceptor();
                wSSEStrippedLoggingInInterceptor2 = new WSSEPasswordMaskedPrettyLoggingInInterceptor();
                wSSEStrippedLoggingOutInterceptor = new WSSEPasswordMaskedPrettyLoggingOutInterceptor();
            }
            endpoint.getInInterceptors().add(wSSEStrippedLoggingInInterceptor);
            endpoint.getInInterceptors().add(wSSEStrippedLoggingInInterceptor2);
            endpoint.getOutInterceptors().add(wSSEStrippedLoggingOutInterceptor);
        }
        if (l != null) {
            this.setTimeout(object, l);
        }
    }

    protected Long getTimeout(Object object) {
        if (this.logDebug) {
            System.out.println("get timeout for service: " + object.toString());
        }
        Client client = ClientProxy.getClient((Object)object);
        HTTPConduit hTTPConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy hTTPClientPolicy = hTTPConduit.getClient();
        return hTTPClientPolicy.getConnectionTimeout();
    }

    protected void setTimeout(Object object, Long l) {
        Client client = ClientProxy.getClient((Object)object);
        if (this.logDebug) {
            System.out.println("set timeout for service: " + client.getConduit().getTarget().getAddress().getValue());
        }
        HTTPConduit hTTPConduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy hTTPClientPolicy = new HTTPClientPolicy();
        hTTPClientPolicy.setConnectionTimeout(l.longValue());
        hTTPClientPolicy.setReceiveTimeout(l.longValue());
        hTTPConduit.setClient(hTTPClientPolicy);
    }

    protected String getUserName() {
        return this.userName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected Object getPortFromUrl(Class clazz, String string) {
        JaxWsProxyFactoryBean jaxWsProxyFactoryBean = new JaxWsProxyFactoryBean();
        jaxWsProxyFactoryBean.setServiceClass(clazz);
        jaxWsProxyFactoryBean.setAddress(string);
        if (this.logDebug) {
            System.out.println("getPortFromUrl: ServiceUrl = " + string);
        }
        return jaxWsProxyFactoryBean.create();
    }

    protected String getPasswordMask(String string) {
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, '*');
        return new String(cArray);
    }

    public SettingsApi getSettingsApi() {
        return this.getSettingsApi(this.defaultTimeout);
    }

    public SettingsApi getSettingsApi(Long l) {
        if (this.settingsApi == null) {
            this.settingsApi = (SettingsApi)this.getPortFromUrl(SettingsApi.class, this.serverUrl + SETTINGS_API_SERVICE_STUB);
            this.instrumentService(this.settingsApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.settingsApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.settingsApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.settingsApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.settingsApi;
    }

    public WorkflowApi getWorkflowApi() {
        return this.getWorkflowApi(this.defaultTimeout);
    }

    public WorkflowApi getWorkflowApi(Long l) {
        if (this.workflowApi == null) {
            this.workflowApi = (WorkflowApi)this.getPortFromUrl(WorkflowApi.class, this.serverUrl + WORKFLOW_API_SERVICE_STUB);
            this.instrumentService(this.workflowApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.workflowApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.workflowApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.workflowApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.workflowApi;
    }

    public DeepLicenseDataApi getDeepLicenseDataApi() {
        return this.getDeepLicenseDataApi(this.defaultTimeout);
    }

    private DeepLicenseDataApi getDeepLicenseDataApi(Long l) {
        if (this.deepLicenseDataApi == null) {
            this.deepLicenseDataApi = (DeepLicenseDataApi)this.getPortFromUrl(DeepLicenseDataApi.class, this.serverUrl + DEEPLICENSEDATA_API_SERVICE_STUB);
            this.instrumentService(this.deepLicenseDataApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.deepLicenseDataApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.deepLicenseDataApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.deepLicenseDataApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.deepLicenseDataApi;
    }

    public ReportApi getReportApi() {
        return this.getReportApi(this.defaultTimeout);
    }

    public ReportApi getReportApi(Long l) {
        if (this.reportApi == null) {
            this.reportApi = (ReportApi)this.getPortFromUrl(ReportApi.class, this.serverUrl + REPORT_API_SERVICE_STUB);
            this.instrumentService(this.reportApi, this.userName, this.password, l);
        } else {
            Long l2 = this.getTimeout(this.deepLicenseDataApi);
            if (l != null && !l.equals(l2)) {
                this.setTimeout(this.deepLicenseDataApi, l);
            }
        }
        if (this.proxyType != null) {
            this.setProxyServer(this.reportApi, this.proxyServer, this.proxyPort, this.proxyType);
        }
        return this.reportApi;
    }
}

