/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.cosine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

class BinaryJarInventoryFileVisitor<T extends Path>
implements FileVisitor<T> {
    Path buildRoot;
    Multimap<HashCode, Path> md5ToFilePathsMap = ArrayListMultimap.create();

    BinaryJarInventoryFileVisitor() {
    }

    public Multimap<HashCode, Path> getMd5ToFilePathsMap() {
        return this.md5ToFilePathsMap;
    }

    public void setBuildRoot(T buildRoot) {
        this.buildRoot = buildRoot;
    }

    @Override
    public FileVisitResult preVisitDirectory(T directory, BasicFileAttributes attributes) throws IOException {
        Path relativePath = this.buildRoot.relativize((Path)directory);
        if (relativePath.endsWith("src/main/java") || relativePath.endsWith("src/test/java") || relativePath.endsWith("src/main/resources")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (relativePath.endsWith("target/reports")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (relativePath.endsWith("tools/config")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(T directory, IOException attributes) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(T filePath, BasicFileAttributes attributes) throws IOException {
        if (filePath.toString().endsWith(".jar") && !filePath.toString().endsWith("-sources.jar")) {
            Path relativePath = this.buildRoot.relativize((Path)filePath);
            this.md5ToFilePathsMap.put(Files.hash(filePath.toFile(), Hashing.md5()), relativePath);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(T filePath, IOException attributes) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

