/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.coverage;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netapp.axx.coverage.ClassInfo;
import com.netapp.common.xml.DOMUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CoverageForJavaFiles
extends Task {
    public static final String CLASS_NAME_COLUMN_HEADER = "Class Name";
    public static final String LINE_RATE_COLUMN_HEADER = "Line Rate";
    public static final String BRANCH_RATE_COLUMN_HEADER = "Branch Rate";
    private List<FileSet> srcFileSets = new ArrayList<FileSet>();
    private String coverageReport;

    public void addFileset(FileSet srcFileSets) {
        this.srcFileSets.add(srcFileSets);
    }

    public void setCoverageReport(String coverageReport) {
        this.coverageReport = coverageReport;
    }

    @Override
    public void execute() {
        Document coberturaDoc;
        DocumentBuilder builder;
        if (this.srcFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        this.log(String.format("Cobertura file at %s", this.coverageReport), 4);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.log("Cannot create document builder for coverage report", e, 1);
            return;
        }
        try {
            coberturaDoc = builder.parse(this.coverageReport);
        }
        catch (SAXException e) {
            this.log("Cannot parse coverage report", e, 1);
            return;
        }
        catch (IOException e) {
            this.log("Cannot process coverage report", e, 1);
            return;
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        ArrayList<ClassInfo> classInfos = Lists.newArrayList();
        for (FileSet srcFileSet : this.srcFileSets) {
            DirectoryScanner scanner = srcFileSet.getDirectoryScanner(this.getProject());
            for (String srcFileName : scanner.getIncludedFiles()) {
                this.log(String.format("Modified src file %s", srcFileName), 4);
                this.processSrcFile(coberturaDoc, xPathFactory, classInfos, srcFileName);
                if (!srcFileName.endsWith("Test.java")) continue;
                String srcFileNameWithOutTest = srcFileName.substring(0, srcFileName.lastIndexOf("Test.java")).concat(".java");
                this.processSrcFile(coberturaDoc, xPathFactory, classInfos, srcFileNameWithOutTest);
                String srcFileNameWithOutNumberedTest = srcFileName.replaceFirst("[0-9]+Test\\.java", ".java");
                if (srcFileNameWithOutNumberedTest.equals(srcFileName)) continue;
                this.processSrcFile(coberturaDoc, xPathFactory, classInfos, srcFileNameWithOutNumberedTest);
            }
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ClassInfo.printCoverageReport(classInfos, printWriter);
        printWriter.flush();
        this.getProject().log(stringWriter.toString(), 2);
    }

    private void processSrcFile(Document coberturaDoc, XPathFactory xPathFactory, List<ClassInfo> classInfos, String srcFileName) {
        try {
            this.log(String.format("Searching for classes in filename %s", srcFileName), 4);
            XPathExpression xPathExpression = xPathFactory.newXPath().compile(String.format("/coverage/packages/package/classes/class[@filename='%s']", srcFileName));
            NodeList classNodes = (NodeList)xPathExpression.evaluate(coberturaDoc, XPathConstants.NODESET);
            if (classNodes.getLength() == 0) {
                this.log(String.format("No classes found for filename %s", srcFileName), 4);
                return;
            }
            for (int i = 0; i < classNodes.getLength(); ++i) {
                ClassInfo classInfo = this.buildClassInfo(classNodes.item(i));
                if (Iterables.any(classInfos, new ClassInfo.NameMatchesPredicate(classInfo.getName()))) {
                    this.log(String.format("Class %s already included in list", classInfo.getName()), 4);
                    continue;
                }
                classInfos.add(classInfo);
            }
        }
        catch (XPathExpressionException e) {
            this.log("Cannot create xpath", e, 1);
            return;
        }
    }

    private ClassInfo buildClassInfo(Node classNode) {
        ClassInfo classInfo = new ClassInfo();
        if (classNode.hasAttributes()) {
            classInfo.setName(DOMUtils.getAttribute((Node)classNode, (String)"name"));
            classInfo.setLineRate(this.multiplyNullSafe(NumberUtils.createFloat(DOMUtils.getAttribute((Node)classNode, (String)"line-rate")), Float.valueOf(100.0f)).floatValue());
            classInfo.setBranchRate(this.multiplyNullSafe(NumberUtils.createFloat(DOMUtils.getAttribute((Node)classNode, (String)"branch-rate")), Float.valueOf(100.0f)).floatValue());
        }
        return classInfo.getName() == null ? null : classInfo;
    }

    private Float multiplyNullSafe(Float arg1, Float arg2) {
        if (arg1 == null || arg2 == null) {
            return null;
        }
        return Float.valueOf(arg1.floatValue() * arg2.floatValue());
    }
}

