/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.coverage;

import com.google.common.collect.Lists;
import com.netapp.axx.coverage.ClassInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ModifiedJavaCoverageReportConsolidator
extends Task {
    private List<FileSet> reportFileSets = new ArrayList<FileSet>();

    public void addFileset(FileSet ratesFileSet) {
        this.reportFileSets.add(ratesFileSet);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        if (this.reportFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        ArrayList<ClassInfo> classInfos = Lists.newArrayList();
        Iterator<FileSet> i$ = this.reportFileSets.iterator();
        block5: while (true) {
            if (!i$.hasNext()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                ClassInfo.printCoverageReport(classInfos, printWriter);
                printWriter.flush();
                this.getProject().log(stringWriter.toString(), 2);
                return;
            }
            FileSet reportFileSet = i$.next();
            DirectoryScanner scanner = reportFileSet.getDirectoryScanner(this.getProject());
            String[] arr$ = scanner.getIncludedFiles();
            int len$ = arr$.length;
            int i$2 = 0;
            while (true) {
                if (i$2 >= len$) continue block5;
                String reportFileName = arr$[i$2];
                this.log(String.format("Coverage report file %s", reportFileName), 4);
                BufferedInputStream inputStream = null;
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(new File(scanner.getBasedir(), reportFileName)));
                    LineIterator lineIterator = IOUtils.lineIterator((InputStream)inputStream, Charset.defaultCharset().displayName());
                    while (lineIterator.hasNext()) {
                        String inputLine = lineIterator.nextLine();
                        if (inputLine.startsWith("=====") || inputLine.startsWith("Class Name") || inputLine.startsWith("No classes to display for module.")) continue;
                        classInfos.add(this.buildClassInfo(inputLine));
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new BuildException(e);
                        catch (IOException e2) {
                            throw new BuildException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(inputStream);
                ++i$2;
            }
            break;
        }
    }

    private ClassInfo buildClassInfo(String inputLine) {
        String[] columns = inputLine.split("\\s+");
        if (columns.length != 3) {
            throw new BuildException(String.format("coverage report line: \"%s\" should have exactly 3 tokens", inputLine));
        }
        return new ClassInfo().withName(columns[0]).withLineRate(columns[1]).withBranchRate(columns[2]);
    }
}

