/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.freemarker;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class FreeMarkerTemplateProcess
extends Task {
    private FileSet templateFileSet;
    private FileSet macroFileSet;
    private String destdir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Need to set the configuration directory to the root of the filesystem to use absolute paths.")
    public void execute() {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader(new ClassTemplateLoader(FreeMarkerTemplateProcess.class, "/"));
        Iterator iterator = this.macroFileSet.iterator();
        while (iterator.hasNext()) {
            FileResource fileResource = (FileResource)iterator.next();
            configuration.addAutoInclude(fileResource.getFile().getAbsolutePath());
        }
        try {
            configuration.setDirectoryForTemplateLoading(new File("/"));
            File destinationDirectory = new File(this.destdir);
            FileUtils.forceMkdir(destinationDirectory);
            Iterator iterator2 = this.templateFileSet.iterator();
            while (iterator2.hasNext()) {
                File file = ((FileResource)iterator2.next()).getFile();
                Template template = configuration.getTemplate(file.getAbsolutePath());
                File processedFile = new File(destinationDirectory, file.getName());
                FileWriter writer = null;
                try {
                    writer = new FileWriter(processedFile);
                    template.process(new HashMap(), writer);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                    return;
                }
                IOUtils.closeQuietly(writer);
            }
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        catch (TemplateException e) {
            throw new BuildException(e);
        }
    }

    public void addTemplates(FileSet fileSet) {
        this.templateFileSet = fileSet;
    }

    public void addMacros(FileSet fileSet) {
        this.macroFileSet = fileSet;
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }
}

