/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.install;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.zeroturnaround.zip.ZipUtil;

public class InstallShieldTask
extends Task {
    private File inputPackageDir;
    private File outputMsiFile = new File("Setup.msi");
    private String restServiceHost;
    private String packageRootPathVar;
    private String serviceDebug = "";
    private String releaseConfiguration = "";
    private String productConfiguration = "";
    private String preprocessorDefines = "";
    private String setupExeCreation = "";
    private String releaseFlags = "";
    private String pathVariable = "";
    private String patchConfig = "";
    private String releaseName = "";
    private String productVersion = "";
    private String propertyDefines = "";
    private String installShieldVersion = "";
    private File zipFile;

    public void setInputPackageDir(File inputPackageDir) {
        this.inputPackageDir = inputPackageDir;
    }

    public void setOutputMsiFile(File outputMsiFile) {
        this.outputMsiFile = outputMsiFile;
    }

    public void setRestServiceHost(String restServiceHost) {
        this.restServiceHost = restServiceHost;
    }

    public void setPackageRootPathVar(String packageRootPathVar) {
        this.packageRootPathVar = packageRootPathVar;
    }

    public void setServiceDebug(String serviceDebug) {
        this.serviceDebug = serviceDebug;
    }

    public void setProductConfiguration(String productConfiguration) {
        this.productConfiguration = productConfiguration;
    }

    public void setReleaseConfiguration(String releaseConfiguration) {
        this.releaseConfiguration = releaseConfiguration;
    }

    public void setPreprocessorDefines(String preprocessorDefines) {
        this.preprocessorDefines = preprocessorDefines;
    }

    public void setSetupExeCreation(String setupExeCreation) {
        this.setupExeCreation = setupExeCreation;
    }

    public void setReleaseFlags(String releaseFlags) {
        this.releaseFlags = releaseFlags;
    }

    public void setPathVariable(String pathVariable) {
        this.pathVariable = pathVariable;
    }

    public void setPatchConfig(String patchConfig) {
        this.patchConfig = patchConfig;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setPropertyDefines(String propertyDefines) {
        this.propertyDefines = propertyDefines;
    }

    public void setInstallShieldVersion(String installShieldVersion) {
        this.installShieldVersion = installShieldVersion;
    }

    @Override
    public void execute() throws BuildException {
        try {
            this.runService();
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runService() throws BuildException, Exception {
        block4: {
            this.generateZipFile();
            InputStream keyStoreStream = this.getClass().getClassLoader().getResourceAsStream("axxservice.jks");
            KeyStore axxTrustStore = KeyStore.getInstance("PKCS12");
            axxTrustStore.load(keyStoreStream, "password".toCharArray());
            keyStoreStream.close();
            SSLContextBuilder sslBuilder = SSLContexts.custom();
            sslBuilder.loadTrustMaterial(axxTrustStore, null);
            SSLContext sslContext = sslBuilder.build();
            SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder = clientBuilder.setSSLSocketFactory(sslConSocFactory);
            CloseableHttpClient client = clientBuilder.build();
            HttpPost httpPost = null;
            httpPost = new HttpPost(new URIBuilder().setScheme("https").setHost(this.restServiceHost).setPort(8443).setPath("/installShield").setParameter("packageRootPathVar", this.packageRootPathVar).setParameter("debug", this.serviceDebug).setParameter("a", this.productConfiguration).setParameter("c", this.releaseConfiguration).setParameter("d", this.preprocessorDefines).setParameter("e", this.setupExeCreation).setParameter("f", this.releaseFlags).setParameter("l", this.pathVariable).setParameter("patch_config", this.patchConfig).setParameter("r", this.releaseName).setParameter("y", this.productVersion).setParameter("z", this.propertyDefines).setParameter("installShieldVersion", this.installShieldVersion).build());
            httpPost.setEntity(MultipartEntityBuilder.create().addBinaryBody("file", this.zipFile).setContentType(ContentType.MULTIPART_FORM_DATA).build());
            httpPost.addHeader("Connection", "Keep-Alive");
            httpPost.addHeader("Cache-Control", "no-cache");
            CloseableHttpResponse response = client.execute(httpPost);
            try {
                if (200 == response.getStatusLine().getStatusCode()) {
                    InputStream inputStream = response.getEntity().getContent();
                    FileOutputStream outputStream = new FileOutputStream(this.outputMsiFile);
                    IOUtils.copy(inputStream, (OutputStream)outputStream);
                    inputStream.close();
                    ((OutputStream)outputStream).close();
                    break block4;
                }
                this.getProject().log(IOUtils.toString(response.getEntity().getContent()).replaceAll("<br/>", System.lineSeparator()));
                throw new BuildException("Error from InstallShield service");
            }
            finally {
                httpPost.releaseConnection();
                response.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateZipFile() throws BuildException {
        if (!this.inputPackageDir.isDirectory()) throw new BuildException("inputPackageDir must be a directory");
        ArrayList<File> subdirs = Lists.newArrayList(this.inputPackageDir.listFiles());
        Collections.sort(subdirs, NameFileComparator.NAME_COMPARATOR);
        if (subdirs.size() != 2 || !"control".equals(((File)subdirs.get(0)).getName()) || !((File)subdirs.get(0)).isDirectory() || !"data".equals(((File)subdirs.get(1)).getName()) || !((File)subdirs.get(1)).isDirectory()) throw new BuildException("inputPackageDir must contain control and data directories");
        try {
            this.zipFile = new File(this.inputPackageDir.getAbsolutePath() + ".zip");
            ZipUtil.pack(this.inputPackageDir, this.zipFile);
            return;
        }
        catch (Exception e) {
            throw new BuildException("Failed to ZIP project source", e);
        }
    }
}

