/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.ivy;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveProcessException;

public class DebugConflictException
extends ResolveProcessException {
    public DebugConflictException(Collection<IvyNode> conflicts, IvyNode parent, IvyNode node1, IvyNode node2) {
        super(DebugConflictException.traceNode(parent, "parent", null) + DebugConflictException.traceNode(parent.getRoot(), "root", null) + DebugConflictException.traceConflictNodes(conflicts, parent) + "node1[" + node1 + "] " + "node2[" + node2 + "] ");
    }

    private static String traceConflictNodes(Collection<IvyNode> conflicts, IvyNode parent) {
        StringBuilder trace = new StringBuilder("conflicts[");
        int i = 1;
        for (IvyNode node : conflicts) {
            trace.append(DebugConflictException.traceNode(node, "conflict" + i, parent));
            ++i;
        }
        trace.append(']');
        return trace.toString();
    }

    private static String traceNode(IvyNode node, String name, IvyNode parent) {
        return name + '[' + node + "] root[" + node.getRoot() + "] moduleID[" + node.getModuleId() + "] resolvedID[" + node.getResolvedId() + "] revision[" + node.getModuleRevision() + DebugConflictException.traceParent(node, parent) + "] confs[" + Arrays.asList(node.getRootModuleConfigurations()) + "] allCallers[" + Arrays.asList(node.getAllCallers()) + "] allRealCallers[" + Arrays.asList(node.getAllRealCallers()) + "] ";
    }

    private static String traceParent(IvyNode node, IvyNode parent) {
        if (parent != null) {
            DependencyDescriptor dd = node.getDependencyDescriptor(parent);
            return "] parentRevision[" + (dd == null ? "null" : dd.getParentRevisionId());
        }
        return "";
    }
}

