/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.parallel;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tools.ant.Project;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class IOHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private IOHelper() {
    }

    public static String readFileToString(File file) {
        StringWriter stringWriter = new StringWriter((int)file.length());
        IOHelper.readFile(file, new WriterCallback(stringWriter));
        return stringWriter.toString();
    }

    public static void readFile(File file, LineCallback lineCallback) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            IOHelper.processStream(reader, lineCallback);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void processStream(BufferedReader reader, LineCallback lineCallback) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            lineCallback.processLine(line);
        }
    }

    public static class ProjectLoggerCallback
    implements LineCallback {
        private final Project project;
        private final int logLevel;

        public ProjectLoggerCallback(Project project, int logLevel) {
            this.project = project;
            this.logLevel = logLevel;
        }

        @Override
        public void processLine(String line) throws IOException {
            this.project.log(line, this.logLevel);
        }
    }

    public static class WriterCallback
    implements LineCallback {
        private final Writer writer;

        public WriterCallback(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void processLine(String line) throws IOException {
            this.writer.append(line);
            this.writer.append(LINE_SEPARATOR);
            this.writer.flush();
        }
    }

    public static interface LineCallback {
        public void processLine(String var1) throws IOException;
    }
}

