/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.parallel;

import com.google.common.base.Strings;
import com.netapp.axx.parallel.IOHelper;
import com.netapp.axx.parallel.UnitFailureException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class ParallelAntExecutor<T extends Unit> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final Pattern SELECTED_HOST_PATTERN = Pattern.compile("rehost start on (\\S+)");
    private List<PropertySet> propertySets = new ArrayList<PropertySet>();
    private List<Property> properties = new ArrayList<Property>();
    private String target;
    private boolean keepLogs = true;
    private String rehostCommandPath = "/usr/software/rats/bin/rehost2.pl";
    private String hostPattern;
    private VerbosityLevel verbosityLevel = VerbosityLevel.VERBOSE;
    private String unitTypeName = "NAME";
    private boolean repeatFirstFailure = true;
    private Integer maxThreads;
    private int maxUnitNameLength;
    private boolean runLocally;
    private boolean skipRemainingAfterUnitFailure;
    private Project project;

    public String millisToString(long durationMillis) {
        long remaining = durationMillis;
        int hours = (int)(remaining / 3600000L);
        int minutes = (int)((remaining -= (long)hours * 3600000L) / 60000L);
        int seconds = (int)((remaining -= (long)minutes * 60000L) / 1000L);
        if (hours != 0) {
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%2d:%02d", minutes, seconds);
    }

    public void execute(List<T> units, UnitLineCallback<T> lineCallback) {
        this.saveMaxUnitNameLength(units);
        ProgressListener progressListener = this.verbosityLevel.createProgressListener(this);
        this.executeUnits(units, progressListener, lineCallback == null ? new NullUnitLineCallback() : lineCallback);
    }

    private void saveMaxUnitNameLength(List<T> units) {
        this.maxUnitNameLength = this.unitTypeName.length();
        for (Unit unit : units) {
            this.maxUnitNameLength = Math.max(this.maxUnitNameLength, unit.getName().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUnits(List<T> units, ProgressListener<T> progressListener, UnitLineCallback<T> lineCallback) {
        Map<T, UnitRunner> runners = this.createRunners(units, lineCallback);
        ArrayList<UnitRunner> failedUnitRunners = new ArrayList<UnitRunner>();
        long startTime = System.currentTimeMillis();
        if (!units.isEmpty()) {
            Thread shutdownHook = this.registerShutdownHook(runners);
            ExecutorService executor = Executors.newFixedThreadPool(this.getActualMaxThreads(units));
            try {
                ExecutorCompletionService<UnitRunner> completionService = new ExecutorCompletionService<UnitRunner>(executor);
                int submitted = this.submitReadyUnits(completionService, runners);
                progressListener.onStart(runners);
                for (int i = 0; i < submitted; ++i) {
                    try {
                        UnitRunner result = (UnitRunner)completionService.take().get();
                        if (result.getStatus() == UnitStatus.FAIL) {
                            failedUnitRunners.add(result);
                            if (this.skipRemainingAfterUnitFailure) {
                                this.skipUnprocessedUnits(runners);
                            }
                        } else {
                            submitted += this.submitReadyUnits(completionService, runners);
                        }
                        progressListener.onUnitFinish(runners, result, i + 1);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                executor.shutdown();
                this.unregisterShutdownHook(shutdownHook);
            }
            try {
                executor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        progressListener.onEnd(runners);
        if (!failedUnitRunners.isEmpty()) {
            if (this.repeatFirstFailure) {
                UnitRunner firstFailed = (UnitRunner)failedUnitRunners.get(0);
                this.printOutput(firstFailed, runners.size(), runners.size(), System.currentTimeMillis() - startTime);
                this.printStateMap(runners);
                throw new UnitFailureException(String.format("%d %s(s) have failed.%nThe output of the first %2$s to fail (%s) has been repeated for easier viewing.", failedUnitRunners.size(), this.unitTypeName.toLowerCase(), firstFailed.getName()));
            }
            throw new UnitFailureException(String.format("%d %s(s) have failed.", failedUnitRunners.size(), this.unitTypeName.toLowerCase()));
        }
        if (!this.keepLogs) {
            for (UnitRunner runner : runners.values()) {
                File outputFile = runner.getOutputFile();
                if (!outputFile.exists() || outputFile.delete()) continue;
                this.project.log(String.format("Could not delete %s", outputFile.getAbsolutePath()), 1);
            }
        }
    }

    public int getActualMaxThreads(List<T> units) {
        return this.maxThreads != null ? Math.min(this.maxThreads, units.size()) : (this.runLocally ? Math.min(Runtime.getRuntime().availableProcessors(), units.size()) : units.size());
    }

    private void unregisterShutdownHook(Thread shutdownHook) {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    private Map<T, UnitRunner> createRunners(List<T> units, UnitLineCallback<T> lineCallback) {
        Map<Unit, UnitRunner> runners = Collections.synchronizedMap(new LinkedHashMap());
        for (Unit unit : units) {
            runners.put(unit, new UnitRunner(this, unit, lineCallback));
        }
        return Collections.unmodifiableMap(runners);
    }

    private Thread registerShutdownHook(final Map<T, UnitRunner> runners) {
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                ParallelAntExecutor.this.project.log("********************************************************************************\nShutdown in progress.\nAny processes spawned on remote hosts will continue running.\nReprinting state table so you can see where each process is running.", 0);
                ParallelAntExecutor.this.printStateMap(runners);
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    private int submitReadyUnits(CompletionService<UnitRunner> completionService, Map<T, UnitRunner> runners) {
        HashMap<String, UnitState> runnerStates = new HashMap<String, UnitState>();
        for (Map.Entry<T, UnitRunner> entry : runners.entrySet()) {
            runnerStates.put(((Unit)entry.getKey()).getName(), entry.getValue().getState());
        }
        int submitted = 0;
        for (Map.Entry<T, UnitRunner> entry : runners.entrySet()) {
            if (entry.getValue().getState() != UnitState.WAITING || !((Unit)entry.getKey()).isReady(runnerStates)) continue;
            entry.getValue().submit(completionService);
            ++submitted;
        }
        return submitted;
    }

    private void skipUnprocessedUnits(Map<T, UnitRunner> runners) {
        for (Map.Entry<T, UnitRunner> entry : runners.entrySet()) {
            entry.getValue().skip();
        }
    }

    private void printOutput(UnitRunner runner, int completedUnits, int totalUnits, long elapsedMillis) {
        this.printConciseProgressStatus(">>> ", runner, completedUnits, totalUnits, elapsedMillis);
        this.project.log(runner.getOutputAsString(), 2);
        this.printConciseProgressStatus("<<< ", runner, completedUnits, totalUnits, elapsedMillis);
    }

    private void printConciseProgressStatus(String prefix, UnitRunner runner, int completedUnits, int totalUnits, long elapsedMillis) {
        this.project.log(String.format("%s%-28s: %-24s [%2d/%2d] %3.0f%% %8s", prefix, runner.getName(), this.target == null ? "" : this.target, completedUnits, totalUnits, (double)completedUnits / (double)totalUnits * 100.0, this.millisToString(elapsedMillis)), 2);
    }

    private void printStateMap(Map<T, UnitRunner> runners) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printStateMapHeader(printWriter);
        for (Map.Entry<T, UnitRunner> entry : runners.entrySet()) {
            this.printStateMapLine(printWriter, entry.getValue());
        }
        this.printStateMapFooter(printWriter);
        printWriter.println("      CTRL-C will not kill spawned processes on remote hosts! Be careful!");
        printWriter.flush();
        this.project.log(stringWriter.toString(), 2);
    }

    private void printStateMapHeader(PrintWriter printWriter) {
        int maxHostNameLength = 51 - this.maxUnitNameLength;
        this.printStateMapFooter(printWriter);
        printWriter.println(String.format(" %-" + this.maxUnitNameLength + "s %-" + maxHostNameLength + "s STATE      RESULT DURATION", this.unitTypeName, "HOST"));
    }

    private void printStateMapLine(PrintWriter printWriter, UnitRunner runner) {
        int maxHostNameLength = 51 - this.maxUnitNameLength;
        UnitState state = runner.getState();
        String hostName = Strings.nullToEmpty(runner.getHostName()).replaceAll("\\..*", "");
        Object[] objectArray = new Object[5];
        objectArray[0] = runner.getName();
        objectArray[1] = hostName;
        objectArray[2] = state;
        Object object = objectArray[3] = state == UnitState.COMPLETE ? runner.getStatus() : "";
        objectArray[4] = state == UnitState.COMPLETE ? this.millisToString(runner.getDuration()) : (state == UnitState.PROCESSING ? "+" + this.millisToString(runner.getDuration()) : "");
        printWriter.println(String.format(" %-" + this.maxUnitNameLength + "s %-" + maxHostNameLength + "s %-11s%6s%9s", objectArray));
    }

    private void printStateMapFooter(PrintWriter printWriter) {
        printWriter.println("================================================================================");
    }

    public void addPropertyset(PropertySet propertySet) {
        this.propertySets.add(propertySet);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setKeepLogs(boolean keepLogs) {
        this.keepLogs = keepLogs;
    }

    public void setRehostCommandPath(String rehostCommandPath) {
        this.rehostCommandPath = rehostCommandPath;
    }

    public void setHostPattern(String hostPattern) {
        this.hostPattern = hostPattern;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setUnitTypeName(String unitTypeName) {
        this.unitTypeName = unitTypeName;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads == null || maxThreads == -1 ? null : maxThreads;
    }

    public void setRepeatFirstFailure(boolean repeatFirstFailure) {
        this.repeatFirstFailure = repeatFirstFailure;
    }

    public void setSkipRemainingAfterUnitFailure(boolean skipRemainingAfterUnitFailure) {
        this.skipRemainingAfterUnitFailure = skipRemainingAfterUnitFailure;
    }

    public void setVerbose(String verbose) {
        this.verbosityLevel = VerbosityLevel.valueOf(verbose.toUpperCase());
    }

    public boolean isRunLocally() {
        return this.runLocally;
    }

    public void setRunLocally(boolean runLocally) {
        this.runLocally = runLocally;
    }

    public static String join(List<String> list, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String element = iterator.next();
            builder.append(element);
            if (!iterator.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    private class NullProgressListener
    implements ProgressListener<T> {
        private NullProgressListener() {
        }

        @Override
        public void onStart(Map<T, UnitRunner> runners) {
        }

        @Override
        public void onUnitFinish(Map<T, UnitRunner> runners, UnitRunner finishedRunner, int completedUnits) {
        }

        @Override
        public void onEnd(Map<T, UnitRunner> runners) {
        }
    }

    private class ConciseProgressListener
    implements ProgressListener<T> {
        private ConciseProgressListener() {
        }

        @Override
        public void onStart(Map<T, UnitRunner> runners) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ParallelAntExecutor.this.printStateMapHeader(printWriter);
            ParallelAntExecutor.this.project.log(stringWriter.toString(), 2);
        }

        @Override
        public void onUnitFinish(Map<T, UnitRunner> runners, UnitRunner finishedRunner, int completedUnits) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ParallelAntExecutor.this.printStateMapLine(printWriter, finishedRunner);
            ParallelAntExecutor.this.project.log(stringWriter.toString(), 2);
            ParallelAntExecutor.this.project.log(finishedRunner.getOutputAsString(), 4);
        }

        @Override
        public void onEnd(Map<T, UnitRunner> runners) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ParallelAntExecutor.this.printStateMapFooter(printWriter);
            ParallelAntExecutor.this.project.log(stringWriter.toString(), 2);
        }
    }

    private class VerboseProgressListener
    implements ProgressListener<T> {
        private long startTime;

        private VerboseProgressListener() {
        }

        @Override
        public void onStart(Map<T, UnitRunner> runners) {
            this.startTime = System.currentTimeMillis();
            ParallelAntExecutor.this.printStateMap(runners);
        }

        @Override
        public void onUnitFinish(Map<T, UnitRunner> runners, UnitRunner finishedRunner, int completedUnits) {
            if (finishedRunner.getStatus() != UnitStatus.SKIP) {
                ParallelAntExecutor.this.printOutput(finishedRunner, completedUnits, runners.size(), System.currentTimeMillis() - this.startTime);
                ParallelAntExecutor.this.printStateMap(runners);
            }
        }

        @Override
        public void onEnd(Map<T, UnitRunner> runners) {
        }
    }

    private static interface ProgressListener<T extends Unit> {
        public void onStart(Map<T, UnitRunner> var1);

        public void onUnitFinish(Map<T, UnitRunner> var1, UnitRunner var2, int var3);

        public void onEnd(Map<T, UnitRunner> var1);
    }

    private static class UnitRunner
    implements Callable<UnitRunner> {
        private final T unit;
        private final UnitLineCallback<T> lineCallback;
        private UnitState state;
        private UnitStatus status;
        private File outputFile;
        private String hostName;
        private Long startTime;
        private Long endTime;
        final /* synthetic */ ParallelAntExecutor this$0;

        UnitRunner(T unit, UnitLineCallback<T> lineCallback) {
            this.this$0 = var1_1;
            this.unit = unit;
            this.lineCallback = lineCallback;
            this.setState(UnitState.WAITING);
            if (((ParallelAntExecutor)var1_1).runLocally) {
                this.hostName = "localhost";
            }
        }

        public Future<UnitRunner> submit(CompletionService<UnitRunner> completionService) {
            this.setState(UnitState.READY);
            return completionService.submit(this);
        }

        public synchronized boolean skip() {
            if (this.getState() == UnitState.WAITING || this.getState() == UnitState.READY) {
                this.setState(UnitState.COMPLETE);
                this.setStatus(UnitStatus.SKIP);
                return true;
            }
            return false;
        }

        private synchronized void setState(UnitState state) {
            this.state = state;
        }

        public synchronized UnitState getState() {
            return this.state;
        }

        public synchronized UnitStatus getStatus() {
            return this.status;
        }

        private synchronized void setStatus(UnitStatus status) {
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UnitRunner call() throws Exception {
            UnitRunner unitRunner = this;
            synchronized (unitRunner) {
                if (this.getStatus() == UnitStatus.SKIP) {
                    return this;
                }
                this.setState(UnitState.PROCESSING);
            }
            this.this$0.project.log(String.format("Starting  %-18s: %s%n", this.unit.getName(), this.this$0.target == null ? "" : this.this$0.target), 4);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.getProcessWorkingDirectory()).redirectErrorStream(true);
            processBuilder.environment().put("ANT_OPTS", this.getAntOpts(processBuilder));
            processBuilder.environment().remove("ANT_CMD_LINE_ARGS");
            if (!this.getOutputFile().getParentFile().exists() && !this.getOutputFile().getParentFile().mkdirs()) {
                this.this$0.project.log(String.format("Could not make directory %s", this.getOutputFile().getParentFile().getAbsolutePath()), 1);
            }
            List<String> command = this.getCommand();
            this.this$0.project.log(String.format("Running command: %s", command), 4);
            UnitRunner unitRunner2 = this;
            synchronized (unitRunner2) {
                this.startTime = System.currentTimeMillis();
            }
            Process process = processBuilder.command(command).start();
            this.copyOutputToFile(process);
            int exitCode = process.waitFor();
            UnitRunner unitRunner3 = this;
            synchronized (unitRunner3) {
                this.endTime = System.currentTimeMillis();
                this.setState(UnitState.COMPLETE);
                this.setStatus(exitCode == 0 ? UnitStatus.PASS : UnitStatus.FAIL);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyOutputToFile(Process process) throws IOException {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(this.getOutputFile()));
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                IOHelper.processStream(reader, new IOHelper.WriterCallback(writer){
                    private boolean keepFindingHost;
                    {
                        this.keepFindingHost = true;
                    }

                    @Override
                    public void processLine(String line) throws IOException {
                        Matcher hostMatcher;
                        super.processLine(line);
                        if (this.keepFindingHost && (hostMatcher = SELECTED_HOST_PATTERN.matcher(line)).find()) {
                            UnitRunner.this.setHostName(hostMatcher.group(1));
                            this.keepFindingHost = false;
                        }
                        UnitRunner.this.lineCallback.processLine(UnitRunner.this.unit, line);
                    }
                });
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }

        private File getProcessWorkingDirectory() {
            return this.unit.getProcessWorkingDirectory();
        }

        private String getAntOpts(ProcessBuilder processBuilder) {
            String antOpts = processBuilder.environment().get("ANT_OPTS");
            if (antOpts != null) {
                int remoteDebugStartIndex = antOpts.indexOf("-agentlib:jdwp");
                if (remoteDebugStartIndex != -1) {
                    int remoteDebugEndIndex = antOpts.indexOf(32, remoteDebugStartIndex);
                    if (remoteDebugEndIndex != -1) {
                        return antOpts.substring(0, remoteDebugStartIndex) + antOpts.substring(remoteDebugEndIndex, antOpts.length());
                    }
                    return antOpts.substring(0, remoteDebugStartIndex);
                }
            } else {
                antOpts = "";
            }
            return antOpts;
        }

        private synchronized File getOutputFile() {
            if (this.outputFile == null) {
                this.outputFile = this.unit.getOutputFile();
            }
            return this.outputFile;
        }

        private List<String> getCommand() {
            if (this.this$0.runLocally) {
                return this.getAntCommand(this.isWindows() ? "\"" : "");
            }
            if (this.isWindows()) {
                throw new BuildException("Remote builds are not supported on windows.");
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.this$0.rehostCommandPath);
            command.add(String.format("--hostpat=%s", this.this$0.hostPattern));
            command.add(String.format("--chdir=%s", this.getProcessWorkingDirectory().getAbsolutePath()));
            command.add("--sendenv");
            command.add("--verbose=1");
            command.add(ParallelAntExecutor.join(this.getAntCommand("'"), " "));
            return command;
        }

        private synchronized String getHostName() {
            return Strings.nullToEmpty(this.hostName);
        }

        public synchronized void setHostName(String hostName) {
            this.hostName = hostName;
        }

        private List<String> getAntCommand(String quoteChar) {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.getAntBinary());
            for (PropertySet propertySet : this.this$0.propertySets) {
                for (Map.Entry<Object, Object> entry : propertySet.getProperties().entrySet()) {
                    this.addPropertyToCommandLine(command, entry.getKey(), entry.getValue(), quoteChar);
                }
            }
            for (Property property : this.this$0.properties) {
                this.addPropertyToCommandLine(command, property.getName(), property.getValue(), quoteChar);
            }
            for (Map.Entry entry : this.this$0.project.getUserProperties().entrySet()) {
                if (((String)entry.getKey()).startsWith("ant")) continue;
                this.addPropertyToCommandLine(command, entry.getKey(), entry.getValue(), quoteChar);
            }
            for (Map.Entry entry : this.unit.getAdditionalAntProperties().entrySet()) {
                this.addPropertyToCommandLine(command, entry.getKey(), entry.getValue(), quoteChar);
            }
            for (BuildListener buildListener : this.this$0.project.getBuildListeners()) {
                if (!(buildListener instanceof BuildLogger)) continue;
                if (!DefaultLogger.class.equals(buildListener.getClass())) {
                    command.add("-logger");
                    command.add(buildListener.getClass().getName());
                }
                if (!(buildListener instanceof DefaultLogger)) continue;
                this.addLogLevelArgument(command, (DefaultLogger)buildListener);
            }
            if (this.this$0.target != null) {
                command.add(this.this$0.target);
            }
            return command;
        }

        private void addPropertyToCommandLine(List<String> command, Object name, Object value, String quoteChar) {
            command.add(String.format("%1$s-D%2$s=%3$s%1$s", quoteChar, name, value));
        }

        private void addLogLevelArgument(List<String> command, DefaultLogger listener) {
            try {
                Field logLevelField = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                logLevelField.setAccessible(true);
                int logLevel = (Integer)logLevelField.get(listener);
                switch (logLevel) {
                    case 1: {
                        command.add("-quiet");
                        break;
                    }
                    case 3: {
                        command.add("-verbose");
                        break;
                    }
                    case 4: {
                        command.add("-debug");
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String getAntBinary() {
            if (this.isWindows()) {
                return new File(new File(System.getProperty("ant.home"), "bin"), "ant.bat").getAbsolutePath();
            }
            return new File(new File(System.getProperty("ant.home"), "bin"), "ant").getAbsolutePath();
        }

        private boolean isWindows() {
            return System.getProperty("os.name").toLowerCase().startsWith("windows");
        }

        public String getOutputAsString() {
            if (this.getOutputFile().exists()) {
                return IOHelper.readFileToString(this.getOutputFile());
            }
            return String.format("Output not available.%nFile %s not found.%nPerhaps you should specify a different outputFilePath?", this.getOutputFile().getAbsolutePath());
        }

        public synchronized long getDuration() {
            if (this.startTime == null) {
                return 0L;
            }
            if (this.endTime == null) {
                return System.currentTimeMillis() - this.startTime;
            }
            return this.endTime - this.startTime;
        }

        public String getName() {
            return this.unit.getName();
        }

        public String toString() {
            return String.format("Runner[%s]", this.getName());
        }
    }

    private static class NullUnitLineCallback<T>
    implements UnitLineCallback<T> {
        private NullUnitLineCallback() {
        }

        @Override
        public void processLine(T unit, String line) {
        }
    }

    public static interface UnitLineCallback<T> {
        public void processLine(T var1, String var2);
    }

    private static enum UnitStatus {
        PASS,
        FAIL{

            public String toString() {
                return "*FAIL*";
            }
        }
        ,
        SKIP;

    }

    public static enum UnitState {
        WAITING,
        READY,
        PROCESSING,
        COMPLETE;

    }

    public static interface Unit {
        public String getName();

        public File getProcessWorkingDirectory();

        public File getOutputFile();

        public Map<String, String> getAdditionalAntProperties();

        public boolean isReady(Map<String, UnitState> var1);
    }

    public static enum VerbosityLevel {
        NONE{

            @Override
            protected <T extends Unit> ProgressListener<T> createProgressListener(ParallelAntExecutor<T> executor) {
                ParallelAntExecutor<T> parallelAntExecutor = executor;
                parallelAntExecutor.getClass();
                return parallelAntExecutor.new NullProgressListener();
            }
        }
        ,
        CONCISE{

            @Override
            protected <T extends Unit> ProgressListener<T> createProgressListener(ParallelAntExecutor<T> executor) {
                ParallelAntExecutor<T> parallelAntExecutor = executor;
                parallelAntExecutor.getClass();
                return parallelAntExecutor.new ConciseProgressListener();
            }
        }
        ,
        VERBOSE{

            @Override
            protected <T extends Unit> ProgressListener<T> createProgressListener(ParallelAntExecutor<T> executor) {
                ParallelAntExecutor<T> parallelAntExecutor = executor;
                parallelAntExecutor.getClass();
                return parallelAntExecutor.new VerboseProgressListener();
            }
        };


        protected abstract <T extends Unit> ProgressListener<T> createProgressListener(ParallelAntExecutor<T> var1);
    }
}

