/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.parallel.subant;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.netapp.axx.parallel.ParallelAntExecutor;
import com.netapp.common.graph.DisplayGraph;
import com.netapp.common.graph.DisplayNode;
import com.netapp.common.graph.Graph;
import com.netapp.common.graph.GraphvizEncoder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.ResourceUtils;

public class ParallelSubAnt
extends IvyTask {
    private final ParallelAntExecutor<ModuleItem> parallelAntExecutor;
    private List<FileSet> buildFileSets = new ArrayList<FileSet>();
    private String ivyFilePath;
    private boolean ignoreDependencies;
    private String outputFilePath;
    private List<String> fromModules;
    private String graphOutputFile;
    private static final Comparator<ModuleItem> BY_REQUIRED_BY_COUNT = new Comparator<ModuleItem>(){

        @Override
        public int compare(ModuleItem o1, ModuleItem o2) {
            if (o1.getRequiredByCount() == o2.getRequiredByCount()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.getRequiredByCount() > o2.getRequiredByCount()) {
                return -1;
            }
            return 1;
        }
    };

    public ParallelSubAnt() {
        this.parallelAntExecutor = new ParallelAntExecutor();
        this.parallelAntExecutor.setUnitTypeName("MODULE");
    }

    public void addFileset(FileSet buildFiles) {
        this.buildFileSets.add(buildFiles);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.parallelAntExecutor.addPropertyset(propertySet);
    }

    public void addProperty(Property property) {
        this.parallelAntExecutor.addProperty(property);
    }

    private File getIvyFileFor(File buildFile) {
        return new File(buildFile.getParentFile(), this.ivyFilePath);
    }

    public void setIvyfilepath(String ivyFilePath) {
        this.ivyFilePath = ivyFilePath;
    }

    public void setTarget(String target) {
        this.parallelAntExecutor.setTarget(target);
    }

    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public void setGraphOutputFile(String graphOutputFile) {
        this.graphOutputFile = graphOutputFile.isEmpty() ? null : graphOutputFile;
    }

    public void setIgnoreDependencies(boolean ignoreDependencies) {
        this.ignoreDependencies = ignoreDependencies;
    }

    public void setKeepLogs(boolean keepLogs) {
        this.parallelAntExecutor.setKeepLogs(keepLogs);
    }

    public void setRehostCommandPath(String rehostCommandPath) {
        this.parallelAntExecutor.setRehostCommandPath(rehostCommandPath);
    }

    public void setHostPattern(String hostPattern) {
        this.parallelAntExecutor.setHostPattern(hostPattern);
    }

    public void setMaxThreads(int maxThreads) {
        this.parallelAntExecutor.setMaxThreads(maxThreads);
    }

    public void setRunLocally(boolean runLocally) {
        this.parallelAntExecutor.setRunLocally(runLocally);
    }

    public void setSkipRemainingAfterModuleFailure(boolean skipRemainingAfterModuleFailure) {
        this.parallelAntExecutor.setSkipRemainingAfterUnitFailure(skipRemainingAfterModuleFailure);
    }

    public void setFromModules(String fromModules) {
        this.fromModules = fromModules == null || fromModules.trim().isEmpty() || "*".equals(fromModules.trim()) ? null : Arrays.asList(fromModules.split(","));
    }

    @Override
    public void setProject(Project project) {
        super.setProject(project);
        this.parallelAntExecutor.setProject(project);
    }

    private String getOutputFilePath() {
        if (this.outputFilePath != null && this.outputFilePath.length() != 0) {
            return this.outputFilePath;
        }
        if (this.parallelAntExecutor.getTarget() != null) {
            return String.format("target%sant-%s.log", System.getProperty("file.separator"), this.parallelAntExecutor.getTarget());
        }
        return String.format("target%sant.log", System.getProperty("file.separator"));
    }

    @Override
    public void doExecute() {
        if (this.buildFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided in ivy build list");
        }
        List<ModuleItem> modules = this.filterFromModules(this.buildModuleItems());
        if (this.graphOutputFile != null) {
            this.printGraphOutput(modules);
        }
        this.parallelAntExecutor.execute(modules, null);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Don't care about return value of mkdirs.")
    private void printGraphOutput(List<ModuleItem> modules) {
        Graph graph = Graph.create();
        for (ModuleItem moduleItem : modules) {
            graph.addNode((Object)moduleItem);
        }
        for (ModuleItem moduleItem : modules) {
            for (ModuleItem dependency : moduleItem.getDirectDependencies()) {
                graph.addEdge((Object)moduleItem, (Object)dependency);
            }
        }
        try {
            this.log(String.format("Writing dependency graph in graphviz dot format to:%n%s", this.graphOutputFile));
            this.log("You can transitively reduce the graph using graphviz's \"tred\" executable.");
            String graphviz = DisplayGraph.fromGraph((String)this.getProject().getName(), (Graph)graph, (Function)new Function<ModuleItem, DisplayNode>(){

                @Override
                public DisplayNode apply(ModuleItem input) {
                    return new DisplayNode(null, input.getName(), null);
                }
            }).toGraphviz(GraphvizEncoder.RankDir.BOTTOM_TO_TOP);
            File graphOutput = new File(this.graphOutputFile);
            graphOutput.getParentFile().mkdirs();
            ResourceUtils.copyResource((Resource)new StringResource(graphviz), (Resource)new FileResource(graphOutput));
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    private List<ModuleItem> filterFromModules(List<ModuleItem> moduleItems) {
        List<ModuleItem> fromModuleItems = this.getFromModuleItems(moduleItems);
        if (fromModuleItems == null || fromModuleItems.isEmpty()) {
            return moduleItems;
        }
        ArrayList<ModuleItem> filteredModules = new ArrayList<ModuleItem>();
        for (ModuleItem moduleItem : moduleItems) {
            if (!moduleItem.dependsOnAny(fromModuleItems)) continue;
            filteredModules.add(moduleItem);
        }
        return filteredModules;
    }

    @SuppressFBWarnings(value={"DLC_DUBIOUS_LIST_COLLECTION"})
    private List<ModuleItem> getFromModuleItems(List<ModuleItem> moduleItems) {
        if (this.fromModules == null) {
            return null;
        }
        ArrayList<ModuleItem> fromModuleItems = new ArrayList<ModuleItem>();
        for (ModuleItem moduleItem : moduleItems) {
            if (!this.fromModules.contains(moduleItem.getName())) continue;
            fromModuleItems.add(moduleItem);
        }
        return fromModuleItems;
    }

    private List<ModuleItem> buildModuleItems() {
        ArrayList<ModuleItem> moduleItems = (ArrayList<ModuleItem>)this.getProject().getReference("module.items");
        if (moduleItems == null) {
            Ivy ivy = this.getIvyInstance();
            IvySettings settings = ivy.getSettings();
            this.ivyFilePath = this.getProperty(this.ivyFilePath, settings, "ivy.buildlist.ivyfilepath");
            moduleItems = new ArrayList<ModuleItem>();
            for (FileSet fs : this.buildFileSets) {
                DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
                for (String buildFileName : scanner.getIncludedFiles()) {
                    File buildFile = new File(scanner.getBasedir(), buildFileName);
                    File ivyFile = this.getIvyFileFor(buildFile);
                    if (!ivyFile.exists()) continue;
                    try {
                        ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, ivyFile.toURI().toURL(), this.doValidate(settings));
                        moduleItems.add(new ModuleItem(md, buildFile, settings.getVersionMatcher()));
                    }
                    catch (Exception ex) {
                        throw new BuildException("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex, ex);
                    }
                }
            }
            for (ModuleItem moduleItem : moduleItems) {
                moduleItem.calculateDirectDependencies(moduleItems);
            }
            for (ModuleItem moduleItem : moduleItems) {
                moduleItem.assertNoCircularRelationships();
            }
            for (ModuleItem moduleItem : moduleItems) {
                moduleItem.propagateRequiredByCount();
            }
            Collections.sort(moduleItems, BY_REQUIRED_BY_COUNT);
            this.getProject().addReference("module.items", moduleItems);
        }
        for (ModuleItem moduleItem : moduleItems) {
            moduleItem.setIgnoreDependencies(this.ignoreDependencies);
            moduleItem.setOutputFilePath(this.getOutputFilePath());
        }
        return moduleItems;
    }

    private static class ModuleItem
    implements ParallelAntExecutor.Unit {
        private final ModuleDescriptor moduleDescriptor;
        private final File buildFile;
        private final VersionMatcher versionMatcher;
        private Collection<ModuleItem> directDependencies;
        private int requiredByCount;
        private boolean ignoreDependencies;
        private String outputFilePath;

        ModuleItem(ModuleDescriptor moduleDescriptor, File buildFile, VersionMatcher versionMatcher) {
            this.moduleDescriptor = moduleDescriptor;
            this.buildFile = buildFile;
            this.versionMatcher = versionMatcher;
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @Override
        public String getName() {
            return this.moduleDescriptor.getModuleRevisionId().getName();
        }

        public int getRequiredByCount() {
            return this.requiredByCount;
        }

        public File getBuildFile() {
            return this.buildFile;
        }

        public void calculateDirectDependencies(Collection<ModuleItem> moduleItems) {
            this.directDependencies = new ArrayList<ModuleItem>();
            for (ModuleItem moduleItem : moduleItems) {
                if (!this.moduleDescriptor.dependsOn(this.versionMatcher, moduleItem.getModuleDescriptor())) continue;
                this.directDependencies.add(moduleItem);
            }
        }

        public void propagateRequiredByCount() {
            ++this.requiredByCount;
            for (ModuleItem dependency : this.directDependencies) {
                dependency.propagateRequiredByCount();
            }
        }

        public void assertNoCircularRelationships() {
            this.recursivelyAssertNoCircularRelationships(new ArrayList<String>());
        }

        private void recursivelyAssertNoCircularRelationships(List<String> dependencyChain) {
            int index = dependencyChain.indexOf(this.getName());
            dependencyChain.add(this.getName());
            if (index != -1) {
                throw new BuildException("Circular dependency found: " + Joiner.on(" -> ").join(dependencyChain.subList(index, dependencyChain.size())));
            }
            for (ModuleItem dependency : this.directDependencies) {
                dependency.recursivelyAssertNoCircularRelationships(new ArrayList<String>(dependencyChain));
            }
        }

        @Override
        public boolean isReady(Map<String, ParallelAntExecutor.UnitState> unitStates) {
            if (this.ignoreDependencies) {
                return true;
            }
            for (ModuleItem moduleItem : this.directDependencies) {
                ParallelAntExecutor.UnitState dependencyState = unitStates.get(moduleItem.getName());
                if (dependencyState == null || dependencyState == ParallelAntExecutor.UnitState.COMPLETE) continue;
                return false;
            }
            return true;
        }

        @Override
        public Map<String, String> getAdditionalAntProperties() {
            return Collections.emptyMap();
        }

        @Override
        public File getProcessWorkingDirectory() {
            return this.getBuildFile().getParentFile();
        }

        @Override
        public File getOutputFile() {
            return new File(this.getProcessWorkingDirectory(), this.outputFilePath);
        }

        public void setOutputFilePath(String outputFilePath) {
            this.outputFilePath = outputFilePath;
        }

        public void setIgnoreDependencies(boolean ignoreDependencies) {
            this.ignoreDependencies = ignoreDependencies;
        }

        public Collection<ModuleItem> getDirectDependencies() {
            return this.directDependencies;
        }

        public boolean dependsOnAny(Collection<ModuleItem> moduleItems) {
            if (moduleItems.contains(this)) {
                return true;
            }
            for (ModuleItem dependency : this.directDependencies) {
                if (!dependency.dependsOnAny(moduleItems)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

