/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.project;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;

public class NewModule
extends Task {
    private static final String RESOURCE_PATH = "/com/netapp/axx/project/";
    private static final List<String> RESOURCES = ImmutableList.of("/com/netapp/axx/project/.checkstyle.template", "/com/netapp/axx/project/.classpath.template", "/com/netapp/axx/project/.p4ignore", "/com/netapp/axx/project/.pmd.template", "/com/netapp/axx/project/.project.template", "/com/netapp/axx/project/build.xml", "/com/netapp/axx/project/build-module.properties", "/com/netapp/axx/project/ivy.xml");
    private String module = "";

    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public void execute() {
        Map<String, String> propertyReplacements = this.buildPropertyReplacements();
        this.extractResources(RESOURCES, new File(PropertyHelper.getProperty((Project)this.getProject(), (String)"basedir") + File.separator + "modules" + File.separator + this.module), propertyReplacements);
    }

    private Map<String, String> buildPropertyReplacements() {
        return ImmutableMap.of("MODULENAME", this.module, "COPYRIGHTYEAR", Integer.toString(Calendar.getInstance().get(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractResources(List<String> resourcesInClasspath, File targetDirectory, Map<String, String> propertyReplacements) {
        if (targetDirectory.exists()) {
            throw new BuildException("Module directory already exists " + targetDirectory);
        }
        if (!(targetDirectory.mkdirs() || targetDirectory.exists() && targetDirectory.isDirectory())) {
            throw new BuildException("Cannot create directory " + targetDirectory);
        }
        for (String resource : resourcesInClasspath) {
            Closer closer = Closer.create();
            File resourceFile = new File(targetDirectory, resource.substring(resource.lastIndexOf(47) + 1));
            try {
                String line;
                BufferedReader reader = closer.register(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource), Charset.defaultCharset())));
                if (reader == null) {
                    throw new BuildException("AXX ERROR: Cannot get resource \"" + resource + "\" from AXX jar file.");
                }
                PrintWriter writer = closer.register(new PrintWriter(resourceFile, Charset.defaultCharset().name()));
                while (null != (line = reader.readLine())) {
                    for (Map.Entry<String, String> entry : propertyReplacements.entrySet()) {
                        line = line.replace("${" + entry.getKey() + "}", entry.getValue());
                    }
                    writer.println(line);
                }
            }
            catch (Exception e) {
                Throwables.propagate(e);
            }
            finally {
                try {
                    closer.close();
                }
                catch (IOException e) {
                    Throwables.propagate(e);
                }
            }
        }
    }
}

