/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.selectors;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.netapp.common.util.CollectionUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class AnnotatedClassSelector
extends BaseExtendSelector {
    private String artifact;
    private List<URL> classpath;
    private String annotation;
    private URLClassLoader classpathClassLoader;
    private Class<? extends Annotation> annotationClass;

    @Override
    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        return this.doesClassFileHaveAnnotation(filename);
    }

    private boolean doesClassFileHaveAnnotation(String filename) {
        this.initializeClasspathClassLoader();
        try {
            this.initializeAnnotationClassObject();
        }
        catch (ClassNotFoundException exception) {
            throw new BuildException("Could not create annotation-class [" + this.annotation + "]" + " for [" + this.getProject().getName(), exception);
        }
        try {
            String filenameWithSystemPathSeparators = FilenameUtils.separatorsToSystem(filename);
            String className = filenameWithSystemPathSeparators.substring(0, filenameWithSystemPathSeparators.lastIndexOf(46)).replace(File.separator, ".");
            Class<?> clazz = this.classpathClassLoader.loadClass(className);
            return clazz.isAnnotationPresent(this.annotationClass);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not load class: " + filename, e);
        }
    }

    public void setClasspath(String classpath) {
        List classpathURLs;
        List<String> jars = Arrays.asList(classpath.split(File.pathSeparator));
        this.getProject().log(String.format("Found the following jars on the classpath: [%n%s%n]", Joiner.on(System.getProperty("line.separator")).join(jars)), 4);
        this.classpath = classpathURLs = CollectionUtils.transformIntoList(jars, (Function)new Function<String, URL>(){

            @Override
            public URL apply(String input) {
                try {
                    return new File(input).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new BuildException("Could not resolve path [" + input + "] as URL.", e);
                }
            }
        });
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    private void initializeClasspathClassLoader() {
        if (this.classpathClassLoader == null) {
            File jarFile = new File(this.artifact);
            if (!jarFile.exists()) {
                throw new BuildException("Artifact file not found [" + this.artifact + "]");
            }
            try {
                URL jarFileURL = jarFile.toURI().toURL();
                this.classpath.add(0, jarFileURL);
                this.classpathClassLoader = new URLClassLoader(this.classpath.toArray(new URL[this.classpath.size()]));
            }
            catch (MalformedURLException e) {
                throw new BuildException("Could not create classpath-classloader for [" + this.getProject().getName(), e);
            }
        }
    }

    private void initializeAnnotationClassObject() throws ClassNotFoundException {
        if (this.annotationClass == null) {
            this.annotationClass = this.classpathClassLoader.loadClass(this.annotation);
        }
    }
}

