/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.symlink;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DeleteSymlinks
extends Task {
    private final List<FileSet> fileSets = new ArrayList<FileSet>();

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    @Override
    public void execute() {
        if (this.fileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided");
        }
        try {
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                this.deleteSymLinks(fileSet.getDir().getCanonicalFile(), scanner.getIncludedFiles());
                this.deleteSymLinks(fileSet.getDir().getCanonicalFile(), scanner.getIncludedDirectories());
            }
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void deleteSymLinks(File baseDirectory, String ... includedFileNames) throws IOException {
        for (String sourceFilePath : includedFileNames) {
            File sourceFile = new File(baseDirectory, sourceFilePath);
            if (!this.isSymlink(sourceFile)) continue;
            this.log(String.format("Deleting symlink %s", sourceFile.getAbsolutePath().replace(this.getProject().getBaseDir().getCanonicalPath() + "/", "")), 2);
            sourceFile.delete();
        }
    }

    private boolean isSymlink(File sourceFile) throws IOException {
        return !sourceFile.getAbsolutePath().equals(sourceFile.getCanonicalPath()) || !sourceFile.isFile() && !sourceFile.isDirectory() && !sourceFile.exists();
    }
}

