/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.platform.keystoremanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeystoreManager {
    private static final char[] KEYSTORE_PASSWORD = "changeit".toCharArray();
    private static final String KEYSTORE_TYPE = "jceks";
    private static final String SYMBOLS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@$%^&*()_+=";
    private static final int PASSWORD_LEN = 12;
    private static final String PARTY_METHOD = "PBE";
    private static final String FILE_PATH_SEPARATOR = File.separator;
    private static final String PASSWORD_FILE_NAME = "platform.keystore";
    private static Random rnd = new Random();
    private String keyStoreDir = "";

    public KeystoreManager(String keyStoreDir) {
        this.setKeystoreDir(keyStoreDir);
    }

    private static boolean checkSyntax(String[] args) {
        if (args.length < 3 || args.length > 4) {
            return false;
        }
        if (!args[1].equalsIgnoreCase("get") && !args[1].equalsIgnoreCase("set")) {
            return false;
        }
        if (args[1].equalsIgnoreCase("get") && args.length != 3) {
            return false;
        }
        return !args[1].equalsIgnoreCase("set") || args.length == 3 || args.length == 4;
    }

    private static void printUsage() {
        System.err.println("Usage : <Full path of keystore dir> get <key name>");
        System.err.println(" or ");
        System.err.println("Usage : <Full path of keystore dir> set <key name>");
        System.err.println(" or ");
        System.err.println("Usage : <Full path of keystore dir> set <key name> <key value>");
    }

    private void setKeystoreDir(String keystoreDir) {
        this.keyStoreDir = keystoreDir;
    }

    private String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    private boolean canRunTool() {
        return new File(this.getKeyStoreDir()).isDirectory();
    }

    public String get(String keyName) throws Exception {
        FileInputStream getKeyStoreFileForReading = null;
        String keyStoreFilePath = this.getKeyStoreFilePath();
        if (!Files.exists(Paths.get(keyStoreFilePath, new String[0]), new LinkOption[0]) || !Files.isReadable(Paths.get(keyStoreFilePath, new String[0]))) {
            return null;
        }
        getKeyStoreFileForReading = new FileInputStream(new File(this.getKeyStoreFilePath()));
        try {
            return this.retrieveValueFromKeyStore(keyName, getKeyStoreFileForReading);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException passEx) {
            throw new Exception("Unable to retrieve the password", passEx);
        }
    }

    public void set(String keyName, String keyValue) throws Exception {
        String keyStoreFilePathStr = this.getKeyStoreFilePath();
        Path keyStoreFilePath = Paths.get(keyStoreFilePathStr, new String[0]);
        FileInputStream getKeyStoreFileForReading = null;
        if (Files.exists(keyStoreFilePath, new LinkOption[0])) {
            getKeyStoreFileForReading = new FileInputStream(new File(keyStoreFilePathStr));
        }
        this.storeValueToKeyStore(keyName, keyValue, getKeyStoreFileForReading);
    }

    public void set(String keyName) throws Exception {
        this.set(keyName, KeystoreManager.getRandomString(12));
    }

    private static String getRandomString(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(SYMBOLS.charAt(rnd.nextInt(SYMBOLS.length())));
        }
        return sb.toString();
    }

    private boolean doesKeyStoreFileExist() {
        return new File(this.getKeyStoreDir() + FILE_PATH_SEPARATOR + PASSWORD_FILE_NAME).exists();
    }

    private void storeValueToKeyStore(String keyName, String keyValue, FileInputStream keyStoreToRead) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeySpecException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        if (keyStoreToRead != null) {
            keyStore.load(keyStoreToRead, KEYSTORE_PASSWORD);
        } else {
            keyStore.load(null, KEYSTORE_PASSWORD);
        }
        SecretKey secretKey = this.createSecretKey(keyValue);
        keyStore.setKeyEntry(keyName, secretKey, KEYSTORE_PASSWORD, null);
        FileOutputStream keyStoreFile = new FileOutputStream(new File(this.getKeyStoreFilePath()));
        keyStore.store(keyStoreFile, KEYSTORE_PASSWORD);
        keyStoreFile.flush();
        keyStoreFile.close();
    }

    private String retrieveValueFromKeyStore(String keyName, FileInputStream keyStoreFileForReading) throws NoSuchAlgorithmException, InvalidKeySpecException, UnrecoverableKeyException, KeyStoreException, CertificateException, IOException {
        if (!this.doesKeyStoreFileExist()) {
            return null;
        }
        char[] password = null;
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PARTY_METHOD);
        SecretKey retrievedKey = (SecretKey)this.retrieveKey(keyName, keyStoreFileForReading);
        if (retrievedKey == null) {
            return null;
        }
        PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(retrievedKey, PBEKeySpec.class);
        password = keySpec.getPassword();
        return new String(password);
    }

    private Key retrieveKey(String keyName, FileInputStream keyStoreFileForReading) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        keyStore.load(keyStoreFileForReading, KEYSTORE_PASSWORD);
        return keyStore.getKey(keyName, KEYSTORE_PASSWORD);
    }

    private SecretKey createSecretKey(String keyValue) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PARTY_METHOD);
        return factory.generateSecret(new PBEKeySpec(keyValue.toCharArray()));
    }

    private String getKeyStoreFilePath() {
        return this.getKeyStoreDir() + FILE_PATH_SEPARATOR + PASSWORD_FILE_NAME;
    }

    public static void main(String[] args) throws Exception {
        KeystoreManager keyStoreManager;
        if (!KeystoreManager.checkSyntax(args)) {
            KeystoreManager.printUsage();
            System.exit(1);
        }
        if (!(keyStoreManager = new KeystoreManager(args[0])).canRunTool()) {
            System.exit(2);
        }
        if (args[1].equalsIgnoreCase("get")) {
            System.out.println(keyStoreManager.get(args[2]));
        } else if (args[1].equalsIgnoreCase("set")) {
            if (args.length == 3) {
                keyStoreManager.set(args[2]);
            } else {
                keyStoreManager.set(args[2], args[3]);
            }
        }
    }
}

