/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */
package com.netapp.collectors.vmware;

import java.util.LinkedHashMap;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;

/**
 * This interface is implemented by the VMWare 2.5 collection factory. 
 * 
 * @author kjoshi
 *
 */
public interface IVMWare25CollectionFactory {

    /**
     * Given the object content array, return datastore vmware objects containing top level collected information.
     * Note this will not return detailed vm and host information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent collected object content
     * @return vmwareDatastores collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareDatastore> createVMWareDatastoreCollectionObjects(ObjectContent[] objectContent);
    
    /**
     * Given the object content array, return resource pool vmware objects containing top level collected information.
     * Note this will not return detailed vm information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent collected object content
     * @return vmwareResourcePools collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareResourcePool> createVMWareResourcePoolCollectionObjects(ObjectContent[] objectContent);
    
    /**
     * Given the object content array, return cluster vmware objects containing top level collected information.
     * Note this will not return detailed host, vm information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent collected object content
     * @return vmwareClusters collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareCluster> createVMWareClusterCollectionObjects(ObjectContent[] objectContent);
    
    /**
     * Given the object content array, return compute resource vmware objects containing top level collected information.
     * Note this will not return detailed host, vm information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent collected object content
     * @return vmwareClusters collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareComputeResource> createVMWareComputeResourceCollectionObjects(ObjectContent[] objectContent);

    /**
     * Given the object content array, return virtual machine vmware objects containing top level collected information.
     * 
     * @param objectContent collected object content
     * @return vmwareVirtualMachines collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareVirtualMachine> createVMWareVirtualMachineCollectionObjects(ObjectContent[] objectContent);
    
    /**
     * Given the object content array, return host vmware objects containing top level collected information.
     * Note this will not return detailed vm information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent collected object content
     * @return vmwareHosts collection object containing information collected from vmware device
     */
    LinkedHashMap<Object, VMWareHost> createVMWareHostCollectionObjects(ObjectContent[] objectContent);
    
    /**
     * Given the object content array, return host vmware objects containing top level collected information.
     * Note this will not return detailed vm information. Only the managed object ids of this information
     * will be populated so later it can be related.
     * 
     * @param objectContent - result.
     * @param hostMor - host object.
     * @return - host object.
     */
    VMWareHost createVMWareHostCollectionObject(ObjectContent[] objectContent, ManagedObjectReference hostMor);
}
