
package com.netapp.collectors.vmware;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.SelectionSpec;

















/**
 * Interface for retrieving data from vim25 api.
 *
 * @author slaplante, dhetti
 */
public interface IVMWare25Dao {/*

    *//** Error retrieving MORs statistics.*//*
    public static final String MSG_ERROR_RETRIEVING_MANAGED_OBJECTS_PROPS = "Error retrieving managed Objects and properties."
            + "Exception Message {0}.";

    *//** Error retrieving performance statistics.*//*
    public static final String MSG_ERROR_RETRIEVING_PERFORMANCE_STATS = "Error retrieving performance statistics."
            + "Exception Message {0}.";

    *//** Error getting refresh rate for host.*//*
    public static final String MSG_ERROR_GETTING_HOST_REFRESH_RATE = "Error retrieving refresh rate for host: {0}. " +
            "Exception Message: {1}.";

    *//** Error getting sampling period for host.*//*
    public static final String MSG_ERROR_GETTING_HOST_SAMPLING_PERIOD = "Error retrieving sampling period for host: {0}. " +
            "Exception Message: {1}.";

    *//** Zero refresh rate for host.*//*
    public static final String MSG_ZERO_HOST_REFRESH_RATE = "The performance provider returned a refresh rate of ZERO " +
            "for statistics generation on host: {0}. " +
            "Using the deafult 20-second refresh rate as the host sampling period.";

    *//** Zero sampling period for host.*//*
    public static final String MSG_ZERO_HOST_SAMPLING_PERIOD = "The performance interval returned a sampling period of ZERO " +
            "for statistics generation on host: {0}. " +
            "Using the deafult 300-second interval as the host sampling period.";

    *//** Error data store folder information.*//*
    public static final String MSG_ERROR_RETRIEVING_DATASTORE_FOLDER_INFO = "Error retrieving datastore folder " +
            "information for datastore: {0}. " +	"Exception Message {1}. Likely cause due to file(s) not found in datastore. " +
            "This is an exception thrown from the SOAP API.";

    *//** Error retrieving data store folder information from host. *//*
    public static final String MSG_ERROR_RETRIEVING_DATASTORE_FOLDER_INFO_FROM_HOST = "Error retrieving datastore folder "
            + "information for datastore \"{0}\" on host: {1}. "
            + "Exception message: {2}. Likely cause due to file(s) not found in datastore. "
            + "This is an exception thrown from the SOAP API.";

    *//** A network error occurred. *//*
    public static final String MSG_NETWORK_ERROR =
            "A network error occurred. This could be caused by a network problem or service no longer responding.";

    *//** Message used when exception occurs querying an object that is deleted or not fully created. *//*
    public static final String MSG_OBJECT_DELETED_OR_NOT_FULLY_CREATED = "Error querying object because it has already been deleted or has not been completely created.";

    *//** Message that is checked to determine if an exception occurred as a result of querying an object that has been deleted or not fully created. *//*
    public static final String OBJECT_NOT_CREATED_ERROR = "object has already been deleted or has not been completely created";

    *//** 4.x Api version. *//*
    public static final String VI4_API_VERSION = "4.";
    *//** 5.x Api version. *//*
    public static final String VI5_API_VERSION = "5.";

    *//** NAS Datastore URL Prefix. *//*
    public static final String nasUrlPrefix = "/vmfs/volumes/";

    *//**
     * This method will perform a targeted query of the VMWare API and return information beginning from the given
     * managed object reference. The given PropertySpec[] will contain what objects and properties to retrieve.
     *
     * @param context VMWareContext object
     * @param searchMor ManagedObjectReference used to determine where to start the search
     * @param propertySpec property spec containing objects and properties to retrieve
     * @return result ObjectSpec array with all the results from the SOAP API
     *//*
    public ObjectContent[] retrieveObjectsAndProperties(IVMWareContext context, ManagedObjectReference searchMor, PropertySpec[] propertySpec);

    *//**
     * This method will query the VMWare API and return all the managed objects and their properties
     * beginning from the given Managed Object Reference. The Managed Object Reference is the parameter
     * used to determine where to start the search. The PropertySpec[] will contain what objects and
     * properties to retrieve.
     *
     * @param context VMWareContext object
     * @param searchMor ManagedObjectReference used to determine where to start the search
     * @param traversalSpec traversal spec used to determine what path to search the inventory
     * @return result ObjectSpec array with all the results from the SOAP API
     *//*
    public ObjectContent[] retrieveObjectsAndPropertiesVirtualCenterDiscovery(IVMWareContext context, ManagedObjectReference searchMor, SelectionSpec[] traversalSpec);

    *//**
     * This method is used to query the VMware API for all the managed objects and their properties from the
     * virtual center. Note: This is a very expensive query therefore this should not be used more than once.
     *
     * @param context VMware connection details.
     * @return - ObjectContent[] as the result.
     *//*
    public ObjectContent[] retrieveAllObjectsAndPropertiesVirtualCenterDiscovery(IVMWareContext context);

    *//**
     * Queries VMware API for all virtual machines on the vCenter.
     *
     * @param context vCenter connection details
     * @return virtualMachineObjectContent object content array containing virtual machine information
     *//*
    ObjectContent[] retrieveAllVirtualMachines(IVMWareContext context);

    *//**
     * This method is used to query the VMware API for Hosts and VM summary from the
     * virtual center.
     *
     * @param context VMware connection details.
     * @return - ObjectContent[] as the result.
     *//*
    public ObjectContent[] retrieveVirtualCenterSummary(IVMWareContext context);


    *//**
     * This method is to retrieve all the option value settings.
     *
     * @param context - VMWare context object.
     * @return - Array of Option value objects.
     *//*
    public OptionValue[] retrieveServiceContentSettings(IVMWareContext context);

    *//**
     * Returns the results of the configuration and mapping details of the given host.
     *
     * @param context - VMware connection details.
     * @param hostMor - VMWareHost object.
     * @return - results.
     *//*
    public ObjectContent[] retrieveHostAndVirtualMachineDetailsForDiscovery(IVMWareContext context, ManagedObjectReference hostMor);

    *//**
     * Returns the results of the configuration and mapping details of the given host.
     *
     * @param context - VMware connection details.
     * @param hostMor - VMWareHost object.
     * @return - results.
     *//*
    public ObjectContent[] retrieveHostAndVirtualMachineDetailsForStatistics(IVMWareContext context, ManagedObjectReference hostMor);

    *//**
     * This method is used to query the VMware API for all the resource pool statistics objects and their properties
     * from the virtual center. Note: This is a very expensive query therefore this should not be used more than once.
     *
     * @param context VMware connection details.
     * @return - ObjectContent[] as the result.
     *//*
    public ObjectContent[] retrieveAllObjectsAndPropertiesVirtualCenterStatistics(IVMWareContext context);

    *//**
     * This method is used to query the VMware API for all the managed objects and their properties from the
     * ESX Host. Note: This is a very expensive query therefore this should not be used more than once.
     *
     * @param context VMware connection details.
     * @return - ObjectContent[] as the result.
     *//*
    public ObjectContent[] retrieveAllObjectsAndPropertiesHostStatistics(IVMWareContext context);

    *//**
     * This method is used to get all the data stores associated with the HostSystem. This method is used to query the
     * VMware API.
     *
     * @param context VMware connection details.
     * @param dataStores - list of data stores.
     * @return - ObjectContent[] as the result.
     *//*
    public ObjectContent[] retrieveAllPropertiesOfHostDataStores(IVMWareContext context,
                                                                 LinkedHashMap<Object, VMWareDatastore> dataStores);

    *//**
     * This retrieves all the available performance metric IDs.
     *
     * @param context - Connection and other information.
     * @return - Map of available metric ids.
     *//*
    public Map<String, Integer> retrieveAvailablePerfMetricIds(IVMWareContext context);

    *//**
     * This method retrieves the host sample period.
     *
     * @param hostMor - Managed Object Reference of the root object.
     * @param context - VMWare API Connection details.
     * @return sampling period.
     *//*
    public int retrieveHostSamplePeriod(ManagedObjectReference hostMor, IVMWareContext context);

    *//**
     * This method is used to query the host statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param hostMor - Host managed object.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveHostStats(IVMWareContext context,	ManagedObjectReference hostMor,
                                                    Integer[] counterIds, int samplePeriod);

    *//**
     * This method is used to query the host lun statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param hostMor - Host managed object.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @param scsiLUNs - Scsi Lun array.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveHostLunStats(IVMWareContext context, ManagedObjectReference hostMor,
                                                       Integer[] counterIds, int samplePeriod, ScsiLun[] scsiLUNs);

    *//**
     * This method is used to query Ethernet port statistics of a host from the VMware API.
     *
     * @param context - vmware context
     * @param hostMor - host managed object reference
     * @param counterIds - statistics counters to query
     * @param samplePeriod - sampling period of the host
     * @param physicalNics - an array of physical network adapters
     * @return results of the performance statistics query
     *//*
    public PerfEntityMetricBase[] retrieveHostEthernetPortStats(IVMWareContext context, ManagedObjectReference hostMor,
                                                                Integer[] counterIds, int samplePeriod, Object[] physicalNics);

    *//**
     * This method is used to query all virtual machine statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param cpuReadySummationCounter - The counter value.
     * @param virtualMachines - list of virtual machines.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveVirtualMachineStats(IVMWareContext context, Integer cpuReadySummationCounter,
                                                              LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines,
                                                              Integer[] counterIds, int samplePeriod);

    *//**
     * This method will query virtual machine data store for the folder information. This will return a list of
     * managed object references of the query results.
     *
     * @param context - VMWare Connection object.
     * @param dataStores - list of data stores.
     * @return - a map of managed objects and data stores.
     * @deprecated - This causes the ESX hostd process to go out of Memory.
     *//*
    public LinkedHashMap<ManagedObjectReference, VMWareDatastore> retrieveVirtualMachineDataStoreFolderInfo(
            IVMWareContext context, LinkedHashMap<Object, VMWareDatastore> dataStores);

    *//**
     * This method will query virtual machine data store for the folder information. This will return a list of
     * managed object references of the query results.
     *
     * @param context - VMWare Connection object.
     * @param host - Host object.
     * @return - task managed object references.
     *//*
    public LinkedHashMap<VMWareVirtualMachine, LinkedHashMap<ManagedObjectReference,VMWareDatastore>>
    retrieveVirtualMachineDataStoreFolderInfo(IVMWareContext context, VMWareHost host);

    *//**
     * This method returns the results for the given task managed object references.
     *
     * @param context - VMWare Connection object.
     * @param taskMors - set of Managed object references.
     * @return - the result as an array of ObjectContent.
     *//*
    public ObjectContent[] retrieveVirtualMachineFolderInfoTaskResults(IVMWareContext context,
                                                                       Set<ManagedObjectReference> taskMors);

    *//**
     * This method is used to query all virtual machine lun statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param virtualMachines - list of virtual machines.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveVirtualMachineLunStats(IVMWareContext context,
                                                                 LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines,
                                                                 Integer[] counterIds, int samplePeriod);

    *//**
     * This method is used to query host datastore statistics for a single datastore from the VMware API.
     *
     * @param context - Connection and other information.
     * @param hostMor - Host managed object.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @param datastore - VMWareDatastore collection object.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveHostNasDatastoreStats(IVMWareContext context, ManagedObjectReference hostMor,
                                                                Integer[] counterIds, int samplePeriod, VMWareDatastore datastore);

    *//**
     * This method is used to query all virtual machine datastore statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param virtualMachines - list of virtual machines.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveVirtualMachineNasDatastoreStats(IVMWareContext context,
                                                                          LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines,
                                                                          Integer[] counterIds, int samplePeriod);

    *//**
     * This method is used to query all virtual machine virtual disk statistics from the VMware API.
     *
     * @param context - Connection and other information.
     * @param vm - virtual machine.
     * @param counterIds - stats counters to query on.
     * @param samplePeriod - sampling period of the ESX Host.
     * @return results of the stats query.
     *//*
    public PerfEntityMetricBase[] retrieveVirtualMachineVirtualDiskStats(IVMWareContext context,
                                                                         VMWareVirtualMachine vm, Integer[] counterIds, int samplePeriod);

    *//**
     * This method is used to retrieve all objects and properties for host discovery.
     *
     * @param context - VMWareContext object.
     * @return - Array of ObjectContent.
     *//*
    public ObjectContent[] retrieveAllObjectsAndPropertiesHostDiscovery(IVMWareContext context);

    *//**l
     * This method is used to retrieve the stats levels of the given VC.
     *
     * @param context - Context.
     * @return - Array of ObjectContext.
     *//*
    public ObjectContent[] retrieveVirtualCenterStatsLevels(IVMWareContext context);

    *//**
     * Returns the version of the VC.
     * @param context - VMWareContext object.
     * @return - version string.
     *//*
    public String retrieveVirtualCenterVersion(IVMWareContext context);

    *//**
     * Returns the version of the api.
     *
     * @param context VMWareContext object.
     * @return apiVersion api version
     *//*
    public String retrieveApiVersion(IVMWareContext context);*/
}
