/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

import javax.xml.datatype.XMLGregorianCalendar;
import java.util.Calendar;

/**
 * This is the IVMWareContext interface. This contains the VMWare connection related information.
 * 
 * @author dhetti
 *
 */
public interface IVMWareContext {
	
    /** An exception occurred attempting to disconnect. */
    public static final String DEBUG_MSG_ERROR_OCCURRED_WHILE_DISCONNECTING = "An exception occurred attempting to disconnect.";
	
	
	/**
	 * Gets the connection object.
	 * 
	 * @return the connection object.
	 */
	public Object getConnection();

	/**
	 * Gets the URL of the vcenter.
	 *
	 * @return the URL of the vcenter.
	 */
	public String getVcURL();

    /**
     * Gets the hostname/IP of the vCenter.
     * @return the vCenter hostname OR IP.
     */
    public String getvCenterHostNameOrIP();

	/**
	 * Gets the ServiceContent object.
	 * 
	 * @return the ServiceContent object.
	 */
	public Object getServiceContent();
	
	/**
	 * Gets the Performance Manager object.
	 * 
	 * @return PerformanceManager object.
	 */
	public Object getPerformanceManager();

	/**
	 * Gets the optionsManager
	 * @return
	 */
	public Object getOptionManager();

	/**
	 * Gets the Property collector object.
	 * 
	 * @return PropertyCollector object.
	 */
	public Object getPropertyCollector();	
	
    /**
     * Gets if this is an embedded ESX.
     * 
     * @return isEmbeddedEsx true if this is an embedded ESX
     */
    public boolean isEmbeddedEsx();
    
    /**
     * Gets if this is an ESX.
     * 
     * @return isEsx true if this is an ESX
     */
    public boolean isEsx();
    
    /**
     * Gets the vim package string.
     * 
     * @return vimPackage vim package string
     */
    public String getVimPackage();

    /**
     * Gets the virtual center instance id.
     * 
     * @return vcInstanceId virtual center instance id
     */
    public Integer getVcInstanceId();
    
    /**
     * Gets the access handle id of the target device.
     * 
     * @return accessHandleId access handle id of the target device
     */
    public long getAccessHandleId();
    
    /**
     * Get the current time.
     * 
     * @return a Calendar object.
     */
    public XMLGregorianCalendar getCurrentTime();

     /**
	 * Get the sample start time for performance data collection.
	 *
	 * @return a Calendar object.
	 */
    public XMLGregorianCalendar getSampleStartTime();

	/**
	 * Get the sample end time for performance data collection.
	 *
	 * @return a Calendar object.
	 */
    public XMLGregorianCalendar getSampleEndTime();
    
    /**
     * Distroy's the context.
     */
    public void destroy();

	public long getEndTime();

	public long getStartTime();

	public void setEndTime(long endTime);

	public void setStartTime(long startTime);

}
