/*
 * Copyright (c) 2019 NetApp Inc.
 *
 */

package com.netapp.collectors.vmware;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;


import com.vmware.vim25.ArrayOfDatastoreHostMount;
import com.vmware.vim25.ArrayOfGuestNicInfo;
import com.vmware.vim25.ArrayOfHostFileSystemMountInfo;
import com.vmware.vim25.ArrayOfHostHostBusAdapter;
import com.vmware.vim25.ArrayOfHostVirtualNic;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.ArrayOfOptionValue;
import com.vmware.vim25.ArrayOfPhysicalNic;
import com.vmware.vim25.ArrayOfScsiLun;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ArrayOfVirtualMachineFileLayoutDiskLayout;
import com.vmware.vim25.DatastoreHostMount;
import com.vmware.vim25.DatastoreInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.HostVirtualNic;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NasDatastoreInfo;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.SharesLevel;
import com.vmware.vim25.VirtualMachineConnectionState;
import com.vmware.vim25.VirtualMachineFileInfo;
import com.vmware.vim25.VirtualMachineFileLayoutDiskLayout;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.VmfsDatastoreInfo;

/**
 * Factory to return collected vmware device information objects using the vim25 api.
 * 
 * @author slaplante
 */
public class VMWare25CollectionFactory implements IVMWare25CollectionFactory {

    /** Invalid device name for Physical NIC message. */
    private static final String MSG_INVALID_PHYSICAL_NIC_DEVICE_NAME = 
        "Skipping Physical NIC with MAC address {0} due to invalid/empty device name";

    
    /** Constant for a virtual machine primary fault tolerant role. */
    private static final Integer FAULT_TOLERANT_PRIMARY_ROLE = 1;
    
    /** Constant for a virtual machine secondary fault tolerant role. */
    private static final Integer FAULT_TOLERANT_SECONDARY_ROLE = 2;
    
    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareDatastore> createVMWareDatastoreCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareDatastore> vmwareDatastores = new LinkedHashMap<Object, VMWareDatastore>();
        /*for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("Datastore")){
                VMWareDatastore datastore = new VMWareDatastore(mor);
                
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
                
                if(dynamicProperty != null){
                    for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                        String propertyName = dynamicProperty[dIndex].getName();
                        
                        if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                            if(propertyName.equals("vm")){
                                ArrayOfManagedObjectReference arrayOfVirtualMachines = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] virtualMachines = arrayOfVirtualMachines.getManagedObjectReference();
                                
                                if(virtualMachines != null){
                                    for(ManagedObjectReference virtualMachine : virtualMachines){
                                        datastore.putVirtualMachine(virtualMachine, new VMWareVirtualMachine(virtualMachine));
                                        logger.debug("VM: " + virtualMachine.get_value() + " added to datastore: " + datastore.getName() + " (" + mor + ")" );
                                    }
                                }
                            }else if(propertyName.equals("host")){
                                ArrayOfDatastoreHostMount arrayOfDatastoreHostMounts = (ArrayOfDatastoreHostMount)dynamicProperty[dIndex].getVal();
                                DatastoreHostMount[] datastoreHostMounts = arrayOfDatastoreHostMounts.getDatastoreHostMount();
                                
                                if(datastoreHostMounts != null){
                                    for(DatastoreHostMount datastoreHostMount : datastoreHostMounts){
                                        datastore.putHost(datastoreHostMount.getKey(), new VMWareHost(datastoreHostMount.getKey()));
                                        datastore.putHostMountInfo(datastoreHostMount.getKey(), datastoreHostMount.getMountInfo());
                                        logger.debug("Host: " + datastoreHostMount.getKey() + " added to datastore: " + mor);
                                    }
                                }
                            }else if(propertyName.equals("info")){
                                // set the name of this datastore
                                DatastoreInfo info = (DatastoreInfo)dynamicProperty[dIndex].getVal();
                                datastore.setName(info.getName());
                                datastore.setDataStoreInfo(info);
                                datastore.setUrl(info.getUrl());
                                
                                if(info instanceof VmfsDatastoreInfo){
                                    VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)info;
                                    datastore.setVmfsUuid(vmfsInfo.getVmfs().getUuid());
                                }else if(info instanceof NasDatastoreInfo){
                                    NasDatastoreInfo nasInfo = (NasDatastoreInfo)info;
                                    datastore.setNasRemoteHost(nasInfo.getNas().getRemoteHost());
                                    datastore.setNasRemotePath(nasInfo.getNas().getRemotePath());
                                }
                            }else if(propertyName.equals("browser")){
                                datastore.setDataStoreBrowserMor(dynamicProperty[dIndex].getVal());
                            }
                        }
                    }
                }
                
                vmwareDatastores.put(mor, datastore);
                logger.debug("Created vmware datasource collection object with mor id: " + mor + " ,datastore name: " + datastore.getName());
            }
        }
        */
        return vmwareDatastores;
    }
    
    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareResourcePool> createVMWareResourcePoolCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareResourcePool> vmwareResourcePools = new LinkedHashMap<Object, VMWareResourcePool>();
       /* for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            
            // check if the collected managed object reference type is a resource pool or virtual application
            // note: virtual applications are resource pools but include more features. For ex: a vApp allows
            // the user to change the startup order of the virtual machines in the vApp
            if(mor.getType().equals("ResourcePool") || mor.getType().equals("VirtualApp")){
                VMWareResourcePool resourcePool = new VMWareResourcePool(mor);
                
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
                
                if(dynamicProperty != null){
                    for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                        String propertyName = dynamicProperty[dIndex].getName();
                        
                        if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                            if(propertyName.equals("name")){
                                // set the name of the resource pool
                                resourcePool.setName(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("parent")){
                                // set the parent managed object id of this resource pool
                                ManagedObjectReference resourcePoolMor = (ManagedObjectReference)dynamicProperty[dIndex].getVal();
                                resourcePool.setParentManagedObject(resourcePoolMor);
                            }else if(propertyName.equals("overallStatus")){
                                // set the overall status of the resource pool
                                resourcePool.setOverallStatus(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("vm")){
                                ArrayOfManagedObjectReference arrayOfVirtualMachines = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] virtualMachines = arrayOfVirtualMachines.getManagedObjectReference();
                                
                                if(virtualMachines != null){
                                    for(ManagedObjectReference virtualMachine : virtualMachines){
                                        resourcePool.putVirtualMachine(virtualMachine, new VMWareVirtualMachine(virtualMachine));
                                        logger.debug("VM: " + virtualMachine.get_value() + " added to resource pool: " + resourcePool.getName() + " (" + mor + ")");
                                    }
                                }
                            }else if(propertyName.equals("resourcePool")){
                                ArrayOfManagedObjectReference arrayOfVirtualMachines = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] childResourcePools = arrayOfVirtualMachines.getManagedObjectReference();
                                
                                // set all the child resource pool managed object ids
                                if(childResourcePools != null){
                                    for(ManagedObjectReference childResourcePool : childResourcePools){
                                        resourcePool.putChildResourcePool(childResourcePool, new VMWareResourcePool(childResourcePool));
                                        logger.debug("Child resource pool: " + childResourcePool.get_value() + " added to resource pool: " + resourcePool.getName() + " (" + mor + ")" );
                                    }
                                }
                            }else if(propertyName.equals("config.cpuAllocation.limit")){
                                resourcePool.setCpuLimit((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.cpuAllocation.shares.shares")){
                                resourcePool.setCpuShares((Integer)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.cpuAllocation.reservation")){
                                resourcePool.setCpuReservation((Long)dynamicProperty[dIndex].getVal());
                            // commented out because of known issue with vi4, we receive incorrect stats info from this property
                            //}else if(propertyName.equals("runtime.cpu.overallUsage")){
                            //  resourcePool.setCpuOverallUsage((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.limit")){
                                resourcePool.setMemoryLimit((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.shares.shares")){
                                resourcePool.setMemoryShares((Integer)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.reservation")){
                                resourcePool.setMemoryReservation((Long)dynamicProperty[dIndex].getVal());
                            }
                            // commented out because of known issue with vi4, we receive incorrect stats info from this property
                            //else if(propertyName.equals("runtime.memory.overallUsage")){
                            //  resourcePool.setMemoryOverallUsage((Long)dynamicProperty[dIndex].getVal());
                            //}
                        }
                    }
                }

                vmwareResourcePools.put(mor, resourcePool);
                logger.debug(" Created vmware resource collection object with mor id: " + mor.get_value() + " ,resourcepool name: " + resourcePool.getName() + 
                		" ,parent managed object id: " + resourcePool.getParentManagedObject() + 
                		" ,overall status: " + resourcePool.getOverallStatus() + 
                		" ,cpu limit: " + resourcePool.getCpuLimit() + 
                		" ,cpu share: " + resourcePool.getCpuShares() + 
                		" ,cpu reservation: " + resourcePool.getCpuReservation() + 
                		" ,memory limit: " + resourcePool.getMemoryLimit() + 
                		" ,memory shares: " + resourcePool.getMemoryShares() + 
                		" ,memory reservations: " + resourcePool.getMemoryReservation());
            }
        }*/
        
        return vmwareResourcePools;
    }
    
    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareCluster> createVMWareClusterCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareCluster> vmwareClusters = new LinkedHashMap<Object, VMWareCluster>();
       /* for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("ClusterComputeResource")){
                VMWareCluster cluster = new VMWareCluster(mor);
            
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
            
                if(dynamicProperty != null){
                    for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                        String propertyName = dynamicProperty[dIndex].getName();
                
                        if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                        
                            if(propertyName.equals("name")){
                                cluster.setName(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("host")){
                                ArrayOfManagedObjectReference arrayOfHostSystems = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] hostSystems = arrayOfHostSystems.getManagedObjectReference();
                            
                                if(hostSystems != null){
                                    for(ManagedObjectReference hostSystem : hostSystems){
                                        // add empty host object containing only its managed object so it can be associated later
                                        cluster.putHost(hostSystem, new VMWareHost(hostSystem));
                                        logger.debug("Host: " + hostSystem.get_value() + " added to cluster: " +  cluster.getName() + " (" + mor + ")");
                                    }
                                }
                            }else if(propertyName.equals("overallStatus")){
                                cluster.setOverallStatus(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("resourcePool")){
                                ManagedObjectReference resourcePoolMor = (ManagedObjectReference)dynamicProperty[dIndex].getVal();
                                
                                if(resourcePoolMor != null){
                                    // set the "Resources" resource pool object containing only the managed object id so it can be associated later
                                    VMWareResourcePool resPool = new VMWareResourcePool(resourcePoolMor);
                                    cluster.putResourcePool(resourcePoolMor, resPool);
                                    cluster.setRootResourcePool(resPool);
                                }
                            }else if(propertyName.equals("configuration.drsConfig.enabled")){
                                cluster.setDrsEnabled((Boolean)dynamicProperty[dIndex].getVal());
                            }
                        }
                    }
                } 
                
                vmwareClusters.put(mor, cluster);
                logger.debug("Created vmware cluster collection object with mor id: " + mor + " ,cluster name: " + cluster.getName()
                		+ " ,overall status: " + cluster.getOverallStatus());
                
            }
        }*/
        
        return vmwareClusters;
    }
    
    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareComputeResource> createVMWareComputeResourceCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareComputeResource> vmwareComputeResource = new LinkedHashMap<Object, VMWareComputeResource>();
        /*for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("ComputeResource")){
                VMWareComputeResource computeResource = new VMWareComputeResource(mor);
            
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
            
                if(dynamicProperty != null){
                    for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                        String propertyName = dynamicProperty[dIndex].getName();
                
                        if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                        
                            if(propertyName.equals("name")){
                                computeResource.setName(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("host")){
                                ArrayOfManagedObjectReference arrayOfHostSystems = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] hostSystems = arrayOfHostSystems.getManagedObjectReference();
                            
                                if(hostSystems != null){
                                    for(ManagedObjectReference hostSystem : hostSystems){
                                        // add empty host object containing only its managed object so it can be associated later
                                        computeResource.putHost(hostSystem, new VMWareHost(hostSystem));
                                        logger.debug("Host: " + hostSystem.get_value()  + " added to computer resource " + computeResource.getName() + " (" + mor + ")" );
                                    }
                                }
                            }else if(propertyName.equals("overallStatus")){
                                computeResource.setOverallStatus(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("resourcePool")){
                                ManagedObjectReference resourcePoolMor = (ManagedObjectReference)dynamicProperty[dIndex].getVal();
                                
                                if(resourcePoolMor != null){
                                    // set the "Resources" resource pool object containing only the managed object id so it can be associated later
                                    VMWareResourcePool resPool = new VMWareResourcePool(resourcePoolMor);
                                    computeResource.putResourcePool(resourcePoolMor, resPool);
                                    computeResource.setRootResourcePool(resPool);
                                }
                            }
                        }
                    }
                } 
                
                vmwareComputeResource.put(mor, computeResource);
                logger.debug("Created vmware compute resource collection object with mor id: " + mor + " ,compute resource name: " + computeResource.getName()
                		+ " ,overall status: " + computeResource.getOverallStatus());
            }
        }*/
        
        return vmwareComputeResource;
    }    
    
    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareVirtualMachine> createVMWareVirtualMachineCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareVirtualMachine> vmwareVirtualMachines = new LinkedHashMap<Object, VMWareVirtualMachine>();
       /* for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("VirtualMachine")){
                VMWareVirtualMachine virtualMachine = new VMWareVirtualMachine(mor);
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
                if(dynamicProperty != null){
                    for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                        String propertyName = dynamicProperty[dIndex].getName();
                        
                        if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                            if(propertyName.equals("name")){
                                logger.debug("vm name=" + dynamicProperty[dIndex].getVal().toString());
                                virtualMachine.setName(dynamicProperty[dIndex].getVal().toString());
                            }else if(propertyName.equals("datastore")){
                                ArrayOfManagedObjectReference arrayOfDataStores = 
                                    (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                                ManagedObjectReference[] dataStores = arrayOfDataStores.getManagedObjectReference();
                                if(dataStores != null){
                                    for (ManagedObjectReference datastore : dataStores) {
                                        virtualMachine.putDataStores(datastore, new VMWareDatastore(datastore));
                                        logger.debug("Datastore: " + datastore.get_value() + " added to vm: " +  virtualMachine.getName() + " (" + virtualMachine.getManagedObject() + ")");
                                    }
                                }
                            }else if(propertyName.equals("runtime.powerState")){
                                VirtualMachinePowerState powerState = (VirtualMachinePowerState)dynamicProperty[dIndex].getVal();
                                virtualMachine.setPowerState(powerState.toString());
                            }else if(propertyName.equals("runtime.connectionState")){
                            	VirtualMachineConnectionState connectionState = (VirtualMachineConnectionState)dynamicProperty[dIndex].getVal();
                                virtualMachine.setConnectionState(connectionState.toString());
                            }else if(propertyName.equals("config.uuid")){
                                virtualMachine.setUuid((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.hardware.numCPU")){
                            	if(((Integer)dynamicProperty[dIndex].getVal()).intValue() <= 0){
                                    virtualMachine.setNumberOfCpu(1);
                                }else {
                                    virtualMachine.setNumberOfCpu((Integer)dynamicProperty[dIndex].getVal());
                                }
                            }else if(propertyName.equals("config.cpuAllocation.limit")){
                                virtualMachine.setCpuLimit((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.cpuAllocation.reservation")){
                            	virtualMachine.setCpuReservation((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.limit")){
                            	virtualMachine.setMemoryLimit((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.reservation")){
                            	virtualMachine.setMemoryReservation((Long)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.memoryAllocation.shares.level")){
                            	virtualMachine.setMemoryShareLevel(((SharesLevel)dynamicProperty[dIndex].getVal()).getValue());
                            }else if(propertyName.equals("config.hardware.memoryMB")){
                            	virtualMachine.setMemoryMB((Integer)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.cpuAllocation.shares.level")){
                            	virtualMachine.setCpuShareLevel(((SharesLevel)dynamicProperty[dIndex].getVal()).getValue());
                            }else if(propertyName.equals("config.memoryAllocation.shares.shares")){
                            	virtualMachine.setMemoryShares((Integer)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.cpuAllocation.shares.shares")){
                            	virtualMachine.setCpuShares((Integer)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("guest.net")){
                            	ArrayOfGuestNicInfo arrayOfGuestNicInfo = (ArrayOfGuestNicInfo)dynamicProperty[dIndex].getVal();
                                GuestNicInfo[] nicInfoArray = arrayOfGuestNicInfo.getGuestNicInfo();
                                    
                                ArrayList<String> ipAddressList = virtualMachine.getIpAddressList();
                                    
                                // ESW-7508: build up list of IP addresses
                                if(nicInfoArray != null){
                                    // guest nic info is available
                                    for(GuestNicInfo nicInfo : nicInfoArray){
                                        String[] arrayOfIpAddresses = nicInfo.getIpAddress();
                                            
                                        if(arrayOfIpAddresses != null){
                                            for(String ipAddress : arrayOfIpAddresses){
                                                if(ipAddress != null){
                                                    ipAddressList.add(ipAddress);
                                                }
                                            }
                                        }
                                    }
                                }	
                            	
                                // set list of ip addresses in virtual machine
                                virtualMachine.setIpAddressList(ipAddressList);
                            }else if(propertyName.equals("guest.ipAddress")){
                            	ArrayList<String> ipAddressList = virtualMachine.getIpAddressList();
                                
                                String ipAddress = (String)dynamicProperty[dIndex].getVal();
                                if(!ipAddress.equals("Unset")){
                                    ipAddressList.add(ipAddress);
                                }
                            	
                                virtualMachine.setIpAddressList(ipAddressList);
                            }else if(propertyName.equals("guest.guestState")){
                                virtualMachine.setGuestState((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("guest.toolsStatus")){
                            	VirtualMachineToolsStatus toolsStatus = (VirtualMachineToolsStatus)dynamicProperty[dIndex].getVal();
                                
                                if(toolsStatus != null){
                                    // set the tools status of the virtual machine
                                    virtualMachine.setToolsStatus(toolsStatus.toString());
                                }
                            }else if(propertyName.equals("guest.toolsVersion")){
                            	String toolsVersion = (String)dynamicProperty[dIndex].getVal();
                                
                                if(toolsVersion != null){
                                    // set the tools version of the virtual machine
                                    virtualMachine.setToolsVersion(toolsVersion.toString());
                                }
                            }else if(propertyName.equals("guest.guestFamily")){
                                virtualMachine.setGuestFamily((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("guest.guestFullName")){
                            	virtualMachine.setGuestGuestFullName((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("guest.hostName")){
                            	virtualMachine.setHostName((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("layout.disk")){
                            	ArrayOfVirtualMachineFileLayoutDiskLayout diskLayout = 
                                    (ArrayOfVirtualMachineFileLayoutDiskLayout)dynamicProperty[dIndex].getVal();
                                if (diskLayout != null && diskLayout.getVirtualMachineFileLayoutDiskLayout() != null) {
                                    virtualMachine.setFileLayoutDiskLayout(diskLayout.getVirtualMachineFileLayoutDiskLayout());
                                    for (int j = 0; j < diskLayout.getVirtualMachineFileLayoutDiskLayout().length; j++) {
                                        VirtualMachineFileLayoutDiskLayout layout = diskLayout.getVirtualMachineFileLayoutDiskLayout(j);
                                        if (layout != null && layout.getDiskFile() != null) {
                                            for (int k = 0; k < layout.getDiskFile().length; k++) {
                                                String diskFilePath = layout.getDiskFile(k);
                                                virtualMachine.addVMDKFolderPath(diskFilePath);
                                            }
                                        }

                                    }
                                }
                            }else if (propertyName.equals("config.hardware.device")) {
                                ArrayOfVirtualDevice virtualDevice = (ArrayOfVirtualDevice) dynamicProperty[dIndex].getVal();
                                String guestName = virtualMachine.getConfigGuestFullName();
                                if (virtualDevice != null) {
                                    virtualMachine.setVirtualDevice(virtualDevice.getVirtualDevice());
                                    for (Object device : (Object[])virtualMachine.getVirtualDevice()) {
                                    	if(guestName != null && guestName.contains("2012")){
                                    		if (device instanceof com.vmware.vim.VirtualDisk || device instanceof com.vmware.vim25.VirtualDisk) {
                                    			String uuid = VMWareHelper.getUUIDFromBackingInfo(VMWareHelper.getBackingFromVirtualDevice(device));
                                    			VMWareVirtualDisk virtualDisk = new VMWareVirtualDisk(device);
                                    			if(uuid != null){
                                    				uuid = uuid.replaceAll("-", "");
                                    				virtualDisk.setUUID(uuid);
                                    				virtualMachine.putVirtualDisk(uuid, virtualDisk);
                                    				logger.debug("Virtual disk: " + virtualDisk.getUUID() + " added to vm: " + virtualMachine.getName() + " (" + mor + ")");
                                    			}
                                    		}
                                    	}else{
                                    		if (device instanceof com.vmware.vim.VirtualDisk || device instanceof com.vmware.vim25.VirtualDisk) {
                                    			int controllerKey = VMWareHelper.getControllerKeyFromVirtualDevice(device);
                                                int busNumber = controllerKey % 10;
                                                int unitNumber = VMWareHelper.getUnitNumberFromVirtualDevice(device);
                                                String scsiId = "scsi" + Integer.toString(busNumber) + ":" + Integer.toString(unitNumber);
                                                VMWareVirtualDisk virtualDisk = new VMWareVirtualDisk(device);
                                                virtualDisk.setScsiId(scsiId);
                                                virtualMachine.putVirtualDisk(scsiId, virtualDisk);	
                                    		}
                                    	}
                                    }
                                }
                            }else if(propertyName.equals("config.guestId")){
                                virtualMachine.setGuestId((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.guestFullName")){
                            	virtualMachine.setConfigGuestFullName((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.files")){
                            	VirtualMachineFileInfo vFileInfo = (VirtualMachineFileInfo)dynamicProperty[dIndex].getVal();
                                if (vFileInfo != null) {
                                    virtualMachine.setLogDirectory(vFileInfo.getLogDirectory());
                                    virtualMachine.setSuspendDirectory(vFileInfo.getSuspendDirectory());
                                    virtualMachine.setSnapshotDirectory(vFileInfo.getSnapshotDirectory());
                                    String vmPath = vFileInfo.getVmPathName();

                                    if (vmPath != null && !vmPath.isEmpty()) {
                                        logger.debug("vmPath=" + vmPath);
                                        if(vmPath.lastIndexOf("/") != -1){
                                           virtualMachine.setVmPathName(vmPath.substring(0, vmPath.lastIndexOf("/"))); 
                                        }else{
                                           virtualMachine.setVmPathName(vmPath);
                                        }
                                    }
                                }
                            }else if(propertyName.equals("config.version")){
                                virtualMachine.setVmHardwareVersion((String)dynamicProperty[dIndex].getVal());
                            }else if(propertyName.equals("config.extraConfig")){
                            	ArrayOfOptionValue arrayOfExtraConfigs = (ArrayOfOptionValue)dynamicProperty[dIndex].getVal();
                                OptionValue[] extraConfigs = arrayOfExtraConfigs.getOptionValue();
                                if(extraConfigs != null){
                                    HashMap<String, String> mapExtraConfigs = new HashMap<String, String>();
                                    for(int extraConfigIndex=0;extraConfigIndex < extraConfigs.length;extraConfigIndex++){
                                        if(extraConfigs[extraConfigIndex] != null){
                                            OptionValue extraConfig = extraConfigs[extraConfigIndex];
                                            if(extraConfig.getKey() != null && extraConfig.getValue() != null){
                                                mapExtraConfigs.put( extraConfig.getKey(), extraConfig.getValue().toString() );
                                            }
                                        }
                                    }
                                    
                                    virtualMachine.setExtraConfig( mapExtraConfigs );
                                }
                            }else if(propertyName.equals("resourcePool")){
                            	ManagedObjectReference resourcePoolMor = (ManagedObjectReference)dynamicProperty[dIndex].getVal();
                                
                                if(resourcePoolMor != null){
                                	// set the "Resources" resource pool object containing only the managed object id so it can be associated later
                                    VMWareResourcePool resPool = new VMWareResourcePool(resourcePoolMor);
                                    virtualMachine.setResourcePool(resPool);
                                }
                            }else if(propertyName.equals("config.template")){
                                Boolean isTemplate = (Boolean) dynamicProperty[dIndex].getVal();
                                virtualMachine.setTemplate(isTemplate);
                            }else if(propertyName.equals("config.ftInfo.role")){
                            	Integer faultTolerantRole = (Integer)dynamicProperty[dIndex].getVal();
                                
                                if(faultTolerantRole != null){
                                    // this virtual machine is enabled for fault tolerance
                                    // check to see if the virtual machine is primary or secondary
                                    if(faultTolerantRole.equals(FAULT_TOLERANT_PRIMARY_ROLE)){
                                        // set this virtual machine as the primary in fault tolerant mode
                                        virtualMachine.setPrimary(true);
                                        virtualMachine.setSecondary(false);
                                    }else if(faultTolerantRole.equals(FAULT_TOLERANT_SECONDARY_ROLE)){
                                        // set this virtual machine as the secondary in fault tolerant mode
                                        virtualMachine.setPrimary(false);
                                        virtualMachine.setSecondary(true);
                                    }
                                }
                            }
                        }
                    }
                }
                
                vmwareVirtualMachines.put(mor, virtualMachine);
            }
        }*/
        
        return vmwareVirtualMachines;
    }

    /**
     * {@inheritDoc}
     */
    public LinkedHashMap<Object, VMWareHost> createVMWareHostCollectionObjects(ObjectContent[] objectContent){
        LinkedHashMap<Object, VMWareHost> vmwareHosts = new LinkedHashMap<Object, VMWareHost>();
        /*for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("HostSystem")){
                VMWareHost host = new VMWareHost(mor);
                
                DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
                populateHostObject(dynamicProperty, host);
                vmwareHosts.put(mor, host);
                logger.debug("Created vmware host collection object with mor id: " + mor + " , host name: " + host.getName());
            }
        }*/
        return vmwareHosts;
    }
    
    /**
     * {@inheritDoc}
     */
    public VMWareHost createVMWareHostCollectionObject(ObjectContent[] objectContent, ManagedObjectReference hostMor){
        VMWareHost host = null;
        /*for(int i=0;i < objectContent.length;i++){
            ManagedObjectReference mor = objectContent[i].getObj();
            if(mor.getType().equals("HostSystem")){
                if(mor.equals(hostMor)){
                    host = new VMWareHost(mor);
                    DynamicProperty[] dynamicProperty = objectContent[i].getPropSet();
                    populateHostObject(dynamicProperty, host);
                    break;
                }else{
                    logger.warn("Query returned multiple hosts when one was expected.");
                }
            }
        }*/
        return host;
    }

    /**
     * Populate the host.
     * 
     * @param dynamicProperty property.
     * @param host - host object.
     */
    private void populateHostObject(DynamicProperty[] dynamicProperty, VMWareHost host) {
        /*if(dynamicProperty != null){
            for(int dIndex=0;dIndex < dynamicProperty.length;dIndex++){
                String propertyName = dynamicProperty[dIndex].getName();
                
                if(!dynamicProperty[dIndex].getVal().getClass().isArray()){
                    if(propertyName.equals("name")){
                    	// set the name of this host
                        host.setName(dynamicProperty[dIndex].getVal().toString());
                        
                        // host's name and 'hostname' are the same. In the VIC you must 
                        // name the host with an FQDN or ip address
                        host.setHostName(dynamicProperty[dIndex].getVal().toString());
                    } else if(propertyName.equals("runtime.powerState")){
                        HostSystemPowerState hostPowerState = (HostSystemPowerState) dynamicProperty[dIndex].getVal();
                        host.setPowerState(hostPowerState.toString());
                    } else if(propertyName.equals("runtime.connectionState")){
                        HostSystemConnectionState hostConnectionState = (HostSystemConnectionState) dynamicProperty[dIndex].getVal();
                        host.setConnectionState(hostConnectionState.toString());
                    } else if(propertyName.equals("runtime.inMaintenanceMode")){
                        host.setMaintenanceMode((Boolean)dynamicProperty[dIndex].getVal());
                    } else if(propertyName.equals("vm")){
                        ArrayOfManagedObjectReference arrayOfVirtualMachines = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                        ManagedObjectReference[] virtualMachines = arrayOfVirtualMachines.getManagedObjectReference();
                        if(virtualMachines != null && virtualMachines.length > 0){
                            for(ManagedObjectReference virtualMachine : virtualMachines){
                                host.putVirtualMachine(virtualMachine, new VMWareVirtualMachine(virtualMachine));
                                logger.debug("VM: " + virtualMachine.get_value() + " added to host: " + host.getName());
                            }
                        }
                    }else if(propertyName.equals("datastore")){
                    	ArrayOfManagedObjectReference arrayOfDataStores = (ArrayOfManagedObjectReference)dynamicProperty[dIndex].getVal();
                    	if(arrayOfDataStores != null && arrayOfDataStores.getManagedObjectReference() != null && 
                    			arrayOfDataStores.getManagedObjectReference().length > 0){
                        	for (ManagedObjectReference datastore : arrayOfDataStores.getManagedObjectReference()) {
        						host.putDataStore(datastore, new VMWareDatastore(datastore));
        						logger.debug("Datastore: " + datastore.get_value() +  " added to host: " + host.getName());
                        	}
                    	}
                    }else if(propertyName.equals("config.network.consoleVnic")){
                    	// add all the console vnics to the host object
                    	ArrayOfHostVirtualNic arrayOfHostVirtualNic = (ArrayOfHostVirtualNic) dynamicProperty[dIndex].getVal();
                    	HostVirtualNic[] consoleVirtualNic = arrayOfHostVirtualNic.getHostVirtualNic();
                    	
                    	ArrayList<String> consoleVnicList = new ArrayList<String>();
                        
                        if(consoleVirtualNic != null){
                            for(HostVirtualNic consoleVnic : consoleVirtualNic){
                                consoleVnicList.add(consoleVnic.getSpec().getIp().getIpAddress());
                            }
                            
			    // set host console vnic ip address list
                            host.setConsoleVNicIpAddress(consoleVnicList);
                        }
                    }else if(propertyName.equals("config.network.vnic")){
                    	// add all the host vnics to the host object
                    	ArrayOfHostVirtualNic arrayOfHostVirtualNic = (ArrayOfHostVirtualNic) dynamicProperty[dIndex].getVal();
                    	HostVirtualNic[] hostVirtualNic = arrayOfHostVirtualNic.getHostVirtualNic();
                    	
                        ArrayList<String> hostVnicList = new ArrayList<String>();
                    
                        if(hostVirtualNic != null){
                            for(HostVirtualNic hostVnic : hostVirtualNic){
                                hostVnicList.add(hostVnic.getSpec().getIp().getIpAddress());
                            }
                            
                            // set host vnic ip address list
                            host.setVnicIPAddress(hostVnicList);
                        }
                    }else if(propertyName.equals("config.network.pnic")){
                        ArrayOfPhysicalNic arrayOfPhysicalNic = (ArrayOfPhysicalNic) dynamicProperty[dIndex].getVal();

                        PhysicalNic[] physicalNicArray = arrayOfPhysicalNic.getPhysicalNic();

                        if (physicalNicArray != null && physicalNicArray.length > 0) {
                            for (PhysicalNic physicalNic : physicalNicArray) {
                                if (physicalNic.getDevice() != null && physicalNic.getDevice() != "") {
                                    VMWarePhysicalNic pnic = new VMWarePhysicalNic();
                                    pnic.setDeviceName(physicalNic.getDevice());
                                    pnic.setMacAddress(physicalNic.getMac());
                                    if (physicalNic.getLinkSpeed() != null) {
                                        pnic.setLinkDuplex(physicalNic.getLinkSpeed().isDuplex());
                                        pnic.setLinkSpeedMB(physicalNic.getLinkSpeed().getSpeedMb());
                                    }

                                    host.putPhysicalNic(pnic.getDeviceName(), pnic);
                                }else{
                                    logger.warn(MessageFormat.format(MSG_INVALID_PHYSICAL_NIC_DEVICE_NAME,
                                            physicalNic.getMac()));
                                }
                            }
                        }
                    }else if(propertyName.equals("config.storageDevice.scsiLun")){
                    	ArrayOfScsiLun luns = (ArrayOfScsiLun)dynamicProperty[dIndex].getVal();
                    	
                    	if(luns.getScsiLun() != null){
                    	    host.setAllScsiLUNs(luns.getScsiLun());
                    	}
                    }else if(propertyName.equals("config.fileSystemVolume.mountInfo")){
                        ArrayOfHostFileSystemMountInfo mountInfo = (ArrayOfHostFileSystemMountInfo)dynamicProperty[dIndex].getVal();
                        
                        if(mountInfo.getHostFileSystemMountInfo() != null){
                            host.setHostFileSystemMountInfo(mountInfo.getHostFileSystemMountInfo());
                        }
                    }else if(propertyName.equals("summary.config.product.name")){
                    	host.setProductName((String)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("summary.config.product.fullName")){
                        host.setProductFullName((String)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("hardware.systemInfo.uuid")){
                    	host.setUuid((String)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("hardware.memorySize")){
                    	host.setMemorySize((Long)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("hardware.cpuInfo.hz")){
                    	host.setCpuHz((Long)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("hardware.cpuInfo.numCpuCores")){
                    	host.setNumberOfCpuCores((Short)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("config.storageDevice.hostBusAdapter")){
                    	ArrayOfHostHostBusAdapter adapters = (ArrayOfHostHostBusAdapter)dynamicProperty[dIndex].getVal();
                    	
                    	if(adapters.getHostHostBusAdapter() != null){
                    	    host.setHostBusAdapter(adapters.getHostHostBusAdapter());
                    	}
                    }else if(propertyName.equals("hardware.cpuInfo.numCpuThreads")){
                    	host.setNumberOfCpuThreads((Short)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("configManager.storageSystem")){
                        host.setStorageSystemMor((ManagedObjectReference)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("summary.config.product.version")){
                        host.setEsxVersion((String)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("summary.config.product.build")){
                        host.setEsxBuild((String)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("systemResources.config.memoryAllocation.limit")) {
                        host.setEffectiveMemory((Long)dynamicProperty[dIndex].getVal());
                    }else if(propertyName.equals("systemResources.config.cpuAllocation.limit")) {
                        host.setEffectiveCpu((Long)dynamicProperty[dIndex].getVal());
                    }
                }
            }
        }*/
    }
    
}
