/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.webservices.metadata.model;

import org.jboss.msc.service.ServiceName;

/**
 * @author <a href="ropalka@redhat.com">Richard Opalka</a>
 */
public abstract class AbstractEndpoint {

    public static final String COMPONENT_VIEW_NAME = AbstractEndpoint.class.getPackage().getName() + "ComponentViewName";
    public static final String WELD_DEPLOYMENT = AbstractEndpoint.class.getPackage().getName() + ".WeldDeployment";
    private final String name;
    private final String className;
    private final ServiceName viewName;

    protected AbstractEndpoint(final String name, final String className, final ServiceName viewName) {
        this.name = name;
        this.className = className;
        this.viewName = viewName;
    }

    public final String getName() {
        return name;
    }

    public final String getClassName() {
        return className;
    }

    public ServiceName getComponentViewName() {
        return viewName;
    }

}
