package com.netapp.platform.passwordmanager;

import java.awt.datatransfer.StringSelection;

import com.netapp.platform.keystoremanager.KeystoreManager;

/**
 * Password Manager - To encrypt a fixed password and store it in
 * keystore file.
 *
 * If keystore is available, it will retrieve the password.
 * If keystore is not available, it will create and retrieve the password.
 *
 * KeyStore is stored in /data/ocie directory in general on linux
 * KeyStore is stored in C:\Program Files\data directory in general on windows
 *
 * Exit status :
 * 1 - Failed  - incorrect usage
 * 0 - Success
 */
public class PasswordManager {

    private static String JBOSS_DB_USER_PASSWD_KEY = "JBOSS_DB_USER_PASSWD_KEY";

    private KeystoreManager keystoreManager = null;

    public PasswordManager(String keyStoreDir) throws Exception {
        keystoreManager = new KeystoreManager(keyStoreDir);
    }

    /**
     * Check the given arguments
     *
     * Valid arguments - 'retrieveJBossPassword' 'Absolute path of data directory'
     * e.g - retrieveJBossPassword /data/ocie
     *
     * @param args
     * @return true if valid arguments are passed
     */
    private static boolean checkSyntax(String[] args) {
        if (args.length < 2 && args.length > 3) {
            return false;
        }

        if ((!args[1].equalsIgnoreCase("retrieveJBossPassword")) &&
            (!args[1].equalsIgnoreCase("changeJBossPassword"))) {
            return false;
        }

        if ((args[1].equalsIgnoreCase("changeJBossPassword")) &&
            ((args.length == 2))) {
            return false;
        }

        return true;
    }

    private static void printUsage() {
        System.err.println("Usage : <Full path of keystore dir> retrieveJBossPassword");
        System.err.println("        <Full path of keystore dir> changeJBossPassword <New Password>");
    }

    //TODO:Non-effective method, Tobe removed in future.
    //Keeping it as a placeholder to be used in install/upgrade.
    public String retrieveJBossPassword() throws Exception {
        return "";
    }

    public void changeJBossPassword(String newPassword) throws Exception {
        keystoreManager.set(JBOSS_DB_USER_PASSWD_KEY, newPassword);
    }

    /**
     * Main
     * @param args
     * @throws Exception
     * First argument is always data directory
     */
    public static void main(String[] args) throws Exception {

        if (!checkSyntax(args)) {
            printUsage();
            System.exit(1);
        }

        PasswordManager passwordManager = new PasswordManager(args[0]);

        if (args[1].equalsIgnoreCase("retrieveJBossPassword")) {
            System.out.println(passwordManager.retrieveJBossPassword());
        } else if (args[1].equalsIgnoreCase("changeJBossPassword")) {
            passwordManager.changeJBossPassword(args[2]);
        }
    }
}
