<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- $Id: //depot/prod/axx/tools_main/plugins/modules/axx-core/src/main/resources/com/netapp/axx/cosine/axx-cosine-build-report.xslt#2 $ -->
<!DOCTYPE xsl:stylesheet [ <!ENTITY nbsp "&#160;"> ]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
    method="html"
    omit-xml-declaration="yes"
    indent="yes"
    />

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>AXX COSINE Build Report</title>
  </head>
  <body>

<style>
.hiddenRow {
 display: none;
 visiblity: hidden;
}

.visibleRow {
 display:
 visibility: visible;
}
    </style>

<script language="JavaScript">
<xsl:comment><![CDATA[
function expandCollapse(showHide) {

        var hideShowDiv = document.getElementById(showHide);
        var col1 = document.getElementById(showHide + "Col1");
        var col2 = document.getElementById(showHide + "Col2");

        if (hideShowDiv.className == 'hiddenRow') {
            col1.innerHTML = col1.innerHTML.replace("[+]", "[-]");
            hideShowDiv.className = 'visibleRow';
            col1.rowSpan = 2;
            col2.rowSpan = 2;
        } else {
            col1.innerHTML = col1.innerHTML.replace("[-]", "[+]");
            hideShowDiv.className = 'hiddenRow';
            col1.rowSpan = 1;
            col2.rowSpan = 1;
        }
    }
//]]></xsl:comment>
</script>

<h1 style="center">AXX COSINE Build Report</h1>

<table border="1" cellpadding="0" cellspacing="0" style="border-collapse:separate;">
  <tr>
    <td style="width:11px;padding:0px;">&nbsp;</td>
    <td style="font-weight:bold;">GAV</td>
    <td style="font-weight:bold;">Binary Artifact</td>
    <td style="font-weight:bold;">Usage</td>
    <td style="font-weight:bold;">Publish Sources</td>
    <td style="font-weight:bold;">KB Component Name</td>
    <td style="font-weight:bold;">KB Component Version</td>
    <td style="font-weight:bold;">KB License</td>
    <td style="font-weight:bold;">KB License Approval</td>
  </tr>

  <xsl:apply-templates select="/buildComponents/component">
    <xsl:sort select="usage" />
    <xsl:sort select="gav" />
  </xsl:apply-templates>

</table>
</body>
</html>
</xsl:template>

<xsl:template match="component">
    <xsl:variable name="precedingComponentCount" select="count(./preceding::component)"/>
  <tr>
    <td rowspan="1" id="rowHidden{$precedingComponentCount}Col1" style="vertical-align:top;width:11px;padding:0px;" onClick="expandCollapse('rowHidden{$precedingComponentCount}');">[+]</td>
    <td rowspan="1" id="rowHidden{$precedingComponentCount}Col2" style="vertical-align:top;"><xsl:value-of select="gav"/>&nbsp;</td>
    <td><xsl:value-of select="binaryArtifact"/></td>
    <td><xsl:value-of select="usage"/></td>
    <td><xsl:value-of select="sourcePublishRequired"/></td>
    <td><xsl:value-of select="kbComponentName"/></td>
    <td><xsl:value-of select="kbComponentVersion"/></td>
    <td><xsl:value-of select="primaryLicense"/></td>
    <td><xsl:value-of select="primaryLicenseApproval"/></td>
  </tr>
  <tr id="rowHidden{$precedingComponentCount}" class="hiddenRow">
    <td colspan="6" style="vertical-align:top;width:100%;padding:0px;">
      <table border="0" cellpadding="5" cellspacing="5"><tr><td style="vertical-align: top;">
<b>MD5&nbsp;Sum:</b>&nbsp;<xsl:value-of select="md5"/><br />
<b>Cache&nbsp;Directory:</b>&nbsp;<xsl:value-of select="cacheDirectory"/><br />
<b>Source&nbsp;Artifact:</b>&nbsp;<xsl:value-of select="sourceArtifact"/><br />
<b>Build&nbsp;Tree&nbsp;Locations:</b><br />
    <xsl:for-each select="buildTreePath">
       <xsl:sort select="." />
-&nbsp;<xsl:value-of select="." /><br/>
    </xsl:for-each>
</td><td style="vertical-align: top;">
&nbsp;&nbsp;&nbsp;&nbsp;
</td><td style="vertical-align: top;">
<b>Component&nbsp;ID:</b>&nbsp;<xsl:value-of select="kbComponentId"/><br />
<b>Component&nbsp;Version&nbsp;ID:</b>&nbsp;<xsl:value-of select="kbComponentVersionId"/><br />
<b>KB&nbsp;Available&nbsp;Licenses:</b><br />
<table border="0" cellpadding="0" cellspacing="0">
    <xsl:for-each select="alternateLicense">
       <xsl:sort select="license" />
<tr><td>&nbsp;&nbsp;<xsl:value-of select="./license" /></td><td>&nbsp;<xsl:value-of select="./licenseApproval" /></td></tr>
    </xsl:for-each>
</table>

      </td></tr></table>
    </td>
  </tr></xsl:template>

</xsl:stylesheet>
