import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import ButtonSpinnerLoader from '../ButtonSpinningLoader/index.js';
import PropTypes from 'prop-types';
import './button.scss.js';

/** Button used in most places  */

var Button = function Button(_ref) {
  var children = _ref.children,
      disabled = _ref.disabled,
      thin = _ref.thin,
      variant = _ref.variant,
      className = _ref.className,
      loading = _ref.loading,
      rest = _objectWithoutProperties(_ref, ["children", "disabled", "thin", "variant", "className", "loading"]);

  return /*#__PURE__*/React__default.createElement("button", _extends({
    className: "Suc-button Suc-".concat(variant, " ").concat(thin ? 'Suc-thin' : '', " ").concat(loading ? 'Suc-loading' : '', " ").concat(className),
    disabled: disabled
  }, rest), loading ? /*#__PURE__*/React__default.createElement(ButtonSpinnerLoader, {
    variant: variant === 'primary' ? 'button-loader' : 'stand-alone'
  }) : children);
};

Button.propTypes = {
  /** variant of button */
  variant: PropTypes.oneOf(['primary', 'secondary']),

  /** thin or thick button */
  thin: PropTypes.bool,

  /** disabled state */
  disabled: PropTypes.bool,

  /** loading state */
  loading: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** button text */
  children: PropTypes.node
};
Button.defaultProps = {
  variant: 'primary',
  className: '',
  loading: false,
  thin: false,
  disabled: false
};

export default Button;
//# sourceMappingURL=index.js.map
