import _extends from '@babel/runtime/helpers/extends';
import _defineProperty from '@babel/runtime/helpers/defineProperty';
import React__default, { useMemo } from 'react';
import { Doughnut } from 'react-chartjs-2';
import useOuterLabelPlugin from './OuterLabelPlugin.js';
import { cloneDeep } from 'lodash';
import './donutChart.scss.js';
import PropTypes from 'prop-types';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
/** Donut chart  */

var DonutChart = function DonutChart(_ref) {
  var data = _ref.data,
      className = _ref.className,
      id = _ref.id,
      centerText = _ref.centerText,
      chartProps = _ref.chartProps,
      chartOptionsProps = _ref.chartOptionsProps;
  var sortedData = useMemo(function () {
    return biggestToMiddle(data);
  }, data);
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-donut-chart ".concat(className)
  }, /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-donut-wrapper'
  }, /*#__PURE__*/React__default.createElement(Doughnut, _extends({
    id: id,
    plugins: [useOuterLabelPlugin()],
    options: _objectSpread({
      responsive: true,
      maintainAspectRatio: false,
      cutoutPercentage: 85,
      tooltips: {
        enabled: false
      },
      animation: {
        animateRotate: false
      },
      plugins: {
        labels: {
          render: function render(_ref2) {
            var index = _ref2.index,
                dataset = _ref2.dataset,
                value = _ref2.value;
            var unit = (dataset === null || dataset === void 0 ? void 0 : dataset.unit[index]) || '';
            return [{
              text: "".concat((dataset === null || dataset === void 0 ? void 0 : dataset.valueLabel[index]) || value, " ").concat(unit)
            }];
          },
          position: 'outside',
          textMargin: 5,
          fontColor: function fontColor(_ref3) {
            var backgroundColor = _ref3.backgroundColor;
            return backgroundColor;
          },
          fontSize: 15
        }
      },
      layout: {
        padding: {
          top: 5
        }
      }
    }, chartOptionsProps),
    legend: {
      display: false
    },
    data: {
      labels: sortedData.map(function (item) {
        return item.label;
      }),
      datasets: [{
        data: sortedData.map(function (item) {
          return item.value;
        }),
        backgroundColor: sortedData.map(function (item) {
          return item.color;
        }),
        unit: sortedData.map(function (item) {
          return item.unit;
        }),
        valueLabel: sortedData.map(function (item) {
          return item.valueLabel;
        })
      }]
    }
  }, chartProps)), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-center-text'
  }, centerText)), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-custom-legends'
  }, data.map(function (item) {
    return /*#__PURE__*/React__default.createElement("div", {
      key: item.label,
      className: 'Suc-custom-legend'
    }, /*#__PURE__*/React__default.createElement("div", {
      className: 'Suc-color-box',
      style: {
        backgroundColor: item.color
      }
    }), /*#__PURE__*/React__default.createElement("div", {
      className: 'Suc-legend-label'
    }, item.label));
  })));
};
/** This function takes and array and put the biggest number in the middle, on radical data scenarios it prevents value label to overlap  */

var biggestToMiddle = function biggestToMiddle(data) {
  var arr = cloneDeep(data);
  arr.sort(function (a, b) {
    return a.value - b.value;
  });
  var arr1 = arr.slice(0, (arr === null || arr === void 0 ? void 0 : arr.length) / 2);
  var arr2 = arr.slice((arr === null || arr === void 0 ? void 0 : arr.length) / 2, arr === null || arr === void 0 ? void 0 : arr.length);
  arr2.sort(function (a, b) {
    return b.value - a.value;
  });
  return arr1.concat(arr2);
};

var dataShape = {
  label: PropTypes.string.isRequired,
  color: PropTypes.string.isRequired,
  value: PropTypes.number.isRequired,
  unit: PropTypes.string,
  valueLabel: PropTypes.string
};
DonutChart.propTypes = {
  /** Data for donut */
  data: PropTypes.arrayOf(PropTypes.shape(dataShape)),

  /** Text or JSX that goes in the middle of the chart */
  centerText: PropTypes.node,

  /** Id - helps to fetch the data with testimIO
   const chart = Object.values(Chart.instances).find(({canvas})=>canvas.id==='[donut-id]')
   console.log(chart.config.data.datasets[0].data)
   */
  id: PropTypes.string,
  className: PropTypes.string,

  /** override chart.js props */
  chartProps: PropTypes.object,

  /** override chart.js options */
  chartOptionsProps: PropTypes.object
};
DonutChart.defaultProps = {
  className: '',
  id: null
};

export default DonutChart;
//# sourceMappingURL=index.js.map
