import React__default from 'react';
import PropTypes from 'prop-types';
import './fieldExtra.scss.js';

var FieldExtra = function FieldExtra(_ref) {
  var error = _ref.error,
      warning = _ref.warning,
      marginTop = _ref.marginTop,
      className = _ref.className;
  var err = error || warning;
  return err ? /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-field-extra ".concat(className),
    style: marginTop && {
      marginTop: marginTop
    },
    title: err
  }, error && /*#__PURE__*/React__default.createElement("span", {
    className: "Suc-error"
  }, "Error:"), warning && /*#__PURE__*/React__default.createElement("span", {
    className: "Suc-warning"
  }, "Warning:"), err) : null;
};

FieldExtra.propTypes = {
  /** error text */
  error: PropTypes.string,

  /** warning text */
  warning: PropTypes.string,

  /** margin-top value - if needed */
  marginTop: PropTypes.string,

  /** custom classname */
  className: PropTypes.string
};
FieldExtra.defaultProps = {
  className: ''
};

export default FieldExtra;
//# sourceMappingURL=index.js.map
