import _defineProperty from '@babel/runtime/helpers/defineProperty';
import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import React__default, { useState } from 'react';
import Popover from '../Popover/index.js';
import './filterPanel.scss.js';
import SvgTableFilter from '../../assets/svgs/table-filter.svg.js';
import CheckBox from '../CheckBox/index.js';
import ButtonBase from '../ButtonBase/index.js';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var FilterPanel = function FilterPanel(_ref) {
  var _ref$column = _ref.column,
      filterState = _ref$column.filterState,
      filterOptions = _ref$column.filterOptions,
      updateColumnFilter = _ref$column.updateColumnFilter;

  var _useState = useState((filterState === null || filterState === void 0 ? void 0 : filterState.values) || {}),
      _useState2 = _slicedToArray(_useState, 2),
      internalState = _useState2[0],
      setInternalState = _useState2[1];

  return /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-filter-panel'
  }, /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-filter-content'
  }, filterOptions && filterOptions.length > 0 && filterOptions.map(function (_ref2) {
    var value = _ref2.value,
        label = _ref2.label;
    return /*#__PURE__*/React__default.createElement(CheckBox, {
      key: value,
      name: value,
      checked: internalState[value] || false,
      onChange: function onChange() {
        return setInternalState(_objectSpread(_objectSpread({}, internalState), {}, _defineProperty({}, value, !internalState[value])));
      }
    }, /*#__PURE__*/React__default.createElement("span", null, label));
  })), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-buttons-row'
  }, /*#__PURE__*/React__default.createElement(ButtonBase, {
    onClick: function onClick() {
      setInternalState({});
      updateColumnFilter({});
    }
  }, "Clear"), /*#__PURE__*/React__default.createElement(ButtonBase, {
    onClick: function onClick() {
      updateColumnFilter(internalState);
    }
  }, "Apply")));
};

var FilterButton = function FilterButton(_ref3) {
  var column = _ref3.column;
  return /*#__PURE__*/React__default.createElement(Popover, {
    appendToBody: true,
    container: /*#__PURE__*/React__default.createElement(SvgTableFilter, null),
    containerClass: 'Suc-internal-filter-trigger-button'
  }, /*#__PURE__*/React__default.createElement(FilterPanel, {
    column: column
  }));
};

export { FilterButton };
//# sourceMappingURL=FilterPanel.js.map
