import React__default from 'react';
import SvgPaginationFirst from '../../assets/svgs/pagination_first.svg.js';
import SvgPaginationPrev from '../../assets/svgs/pagination_prev.svg.js';
import SvgPaginationNext from '../../assets/svgs/pagination_next.svg.js';
import SvgPaginationLast from '../../assets/svgs/pagination_last.svg.js';
import ButtonBase from '../ButtonBase/index.js';
import './paginationPanel.scss.js';

var PaginationPanel = (function (_ref) {
  var _ref$pagination = _ref.pagination,
      goToPage = _ref$pagination.gotoPage,
      pageCount = _ref$pagination.pageCount,
      pageIndex = _ref$pagination.pageIndex,
      pageRows = _ref$pagination.pageRows,
      pageSize = _ref.pageSize,
      columnCount = _ref.columnCount,
      totalRows = _ref.totalRows;
  var first = pageIndex * pageSize + 1;
  var last = first + pageRows.length - 1;

  var handlePrev = function handlePrev() {
    return goToPage(pageIndex - 1);
  };

  var handleNext = function handleNext() {
    return goToPage(pageIndex + 1);
  };

  var isFirstPage = pageIndex === 0;
  var isLastPage = pageIndex === pageCount - 1;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-pagination-panel",
    style: {
      gridColumn: "1 / ".concat(columnCount)
    }
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-pagination-title"
  }, "".concat(first === last ? first : "".concat(first, " - ").concat(last), " of ").concat(totalRows)), /*#__PURE__*/React__default.createElement(ButtonBase, {
    type: 'button',
    onClick: function onClick() {
      return goToPage(0);
    },
    disabled: isFirstPage,
    className: "Suc-pagination-button Suc-prev ".concat(isFirstPage ? 'disabled' : '')
  }, /*#__PURE__*/React__default.createElement(SvgPaginationFirst, null)), /*#__PURE__*/React__default.createElement(ButtonBase, {
    type: 'button',
    onClick: handlePrev,
    disabled: isFirstPage,
    className: "Suc-pagination-button ".concat(isFirstPage ? 'disabled' : '')
  }, /*#__PURE__*/React__default.createElement(SvgPaginationPrev, null)), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-current-page'
  }, pageIndex + 1), /*#__PURE__*/React__default.createElement(ButtonBase, {
    type: 'button',
    onClick: handleNext,
    disabled: isLastPage,
    className: "Suc-pagination-button ".concat(isFirstPage ? 'disabled' : '')
  }, /*#__PURE__*/React__default.createElement(SvgPaginationNext, null)), /*#__PURE__*/React__default.createElement(ButtonBase, {
    type: 'button',
    onClick: function onClick() {
      return goToPage(pageCount - 1);
    },
    disabled: isLastPage,
    className: "Suc-pagination-button Suc-next ".concat(isFirstPage ? 'disabled' : '')
  }, /*#__PURE__*/React__default.createElement(SvgPaginationLast, null)));
});

export default PaginationPanel;
//# sourceMappingURL=PaginationPanel.js.map
