import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import CheckBox from '../CheckBox/index.js';
import SvgSelectedV from '../../assets/svgs/selected_v.svg.js';
import ButtonBase from '../ButtonBase/index.js';
import './selection.scss.js';

var SelectionCell = function SelectionCell(_ref) {
  var selectionType = _ref.selectionType,
      props = _objectWithoutProperties(_ref, ["selectionType"]);

  return selectionType === SELECTION_TYPE.MULTIPLE ? /*#__PURE__*/React__default.createElement(MultipleSelectionCell, props) : /*#__PURE__*/React__default.createElement(SingleSelectionCell, props);
};

var MultipleSelectionCell = function MultipleSelectionCell(_ref2) {
  var isSelected = _ref2.isSelected,
      onClick = _ref2.onClick,
      disabled = _ref2.disabled;
  return /*#__PURE__*/React__default.createElement(CheckBox, {
    checked: isSelected,
    onChange: onClick,
    disabled: disabled
  });
};

var SingleSelectionCell = function SingleSelectionCell(_ref3) {
  var isSelected = _ref3.isSelected,
      onClick = _ref3.onClick,
      disabled = _ref3.disabled;
  return /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: 'Suc-singular-selection-cell',
    onClick: onClick,
    disabled: disabled
  }, isSelected ? /*#__PURE__*/React__default.createElement(SvgSelectedV, {
    checked: isSelected
  }) : null);
};

var SELECTION_TYPE = {
  NONE: 'NONE',
  SINGULAR: 'SINGULAR',
  MULTIPLE: 'MULTIPLE'
};

export { SELECTION_TYPE, SelectionCell };
//# sourceMappingURL=Selection.js.map
