import _toConsumableArray from '@babel/runtime/helpers/toConsumableArray';
import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import _defineProperty from '@babel/runtime/helpers/defineProperty';
import React__default, { useMemo, useReducer, useCallback } from 'react';
import _ from 'lodash';
import { SelectionCell, SELECTION_TYPE } from './Selection.js';
import useRunOnceWhenTruthy from '../../hooks/useRunOnceWhenTruthy.js';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var sort = function sort(sortState, columnsMap, rows) {
  return _.orderBy(rows, [columnsMap[sortState.column].accessor], [sortState.sortOrder]);
};

var filter = function filter(filterState, rows, columns, columnsMap) {
  var textFilter = filterState.textFilter;
  return _.filter(rows, function (row) {
    var lowerCaseTextFilter = textFilter && textFilter.toLowerCase();
    var isTextFilterMatch = !textFilter;

    if (textFilter) {
      _.forEach(columns, function (column) {
        var value = row[column.accessor];

        if (_.isString(value) && value.toLowerCase().includes(lowerCaseTextFilter)) {
          isTextFilterMatch = true;
          return false;
        } else if (_.isArray(value) && value.join(', ').toLowerCase().includes(lowerCaseTextFilter)) {
          isTextFilterMatch = true;
          return false;
        }
      });
    }

    var isMultiFilterMatch = true;

    _.forEach(filterState.columns, function (filter, key) {
      if (_.isObject(filter) && filter.activeCount > 0) {
        var accessor = columnsMap[key].accessor;

        if (_.isArray(row[accessor])) {
          var existsOne = _.find(row[accessor], function (value) {
            return filter.values[value];
          });

          if (!existsOne) {
            isMultiFilterMatch = false;
            return false;
          }
        } else {
          if (!filter.values[row[accessor]]) {
            isMultiFilterMatch = false;
            return false;
          }
        }
      }
    });

    return isTextFilterMatch && isMultiFilterMatch;
  });
};

var init = function init(initialState) {
  var sortState = null;

  if (initialState.isSorting) {
    sortState = {
      column: _.isString(initialState.columns[0]) ? initialState.columns[0] : initialState.columns[0].id || '0',
      sortOrder: 'asc'
    };
  }

  var initialPageState = initialState.pageSize ? {
    pageIndex: 0
  } : undefined;
  return {
    sortState: initialState.defaultSortState || sortState,
    defaultSortState: initialState.defaultSortState || sortState,
    defaultFilterState: initialState.defaultFilterState || {
      columns: {},
      count: 0
    },
    tableState: _objectSpread({}, initialState.defaultTableState) || {},
    rowState: {},
    columnState: {},
    selectionState: initialState.selectionType !== SELECTION_TYPE.NONE ? {
      rows: {},
      count: 0
    } : undefined,
    selectionType: initialState.selectionType,
    filterState: initialState.defaultFilterState || {
      columns: {},
      count: 0
    },
    pageState: initialPageState,
    initialPageState: initialPageState
  };
};

var reducer = function reducer(state, action) {
  var type = action.type,
      payload = action.payload;

  switch (type) {
    case 'TOGGLE-SORT':
      {
        var id = payload.id;
        var newSortState = {};
        var currentSortOrder = state.sortState.sortOrder;
        var currentSortColumn = state.sortState.column;

        if (currentSortColumn === id) {
          if (currentSortOrder === 'asc') {
            newSortState.sortOrder = 'desc';
            newSortState.column = id;
          } else if (currentSortColumn !== state.defaultSortState.column) {
            newSortState = state.defaultSortState;
          } else {
            newSortState.sortOrder = 'asc';
            newSortState.column = id;
          }
        } else {
          newSortState.sortOrder = 'asc';
          newSortState.column = id;
        }

        return _objectSpread(_objectSpread({}, state), {}, {
          sortState: newSortState,
          pageState: state.initialPageState
        });
      }

    case 'SET-FILTER':
      {
        var _id = payload.id,
            values = payload.values;

        var newValues = _.pickBy(values);

        var newColumnFilter = {
          values: newValues,
          valuesArray: _.values(values),
          activeCount: _.size(newValues)
        };

        var columns = _objectSpread(_objectSpread({}, state.filterState.columns), {}, _defineProperty({}, _id, newColumnFilter));

        var count = 0;

        _.forEach(columns, function (state) {
          if (state.activeCount > 0) {
            count = count + 1;
          }
        });

        return _objectSpread(_objectSpread({}, state), {}, {
          filterState: _objectSpread(_objectSpread({}, state.filterState), {}, {
            columns: columns,
            count: count
          }),
          pageState: state.initialPageState
        });
      }

    case 'RESET-FILTERS':
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          filterState: _objectSpread(_objectSpread({}, state.filterState), state.defaultFilterState),
          pageState: state.initialPageState
        });
      }

    case 'TOGGLE-ROW-SELECTION':
      {
        var _id2 = payload.id,
            value = payload.value;
        var _count = state.selectionState.count;
        var updatedValue = value;
        var oldSelectedRows = state.selectionState.rows;

        if (state.selectionType === SELECTION_TYPE.MULTIPLE) {
          var currentValue = state.selectionState.rows[_id2] || false;

          if (currentValue && !value) {
            _count = _count - 1;
          } else if (!currentValue && value) {
            _count = _count + 1;
          }
        }

        if (state.selectionType === SELECTION_TYPE.SINGULAR) {
          _count = 1;
          updatedValue = true;
          oldSelectedRows = {};
        }

        return _objectSpread(_objectSpread({}, state), {}, {
          selectionState: {
            count: _count,
            rows: _objectSpread(_objectSpread({}, oldSelectedRows), {}, _defineProperty({}, _id2, updatedValue))
          }
        });
      }

    case 'TOGGLE-SELECT-ALL':
      {
        var _value = payload.value,
            rows = payload.rows;
        var selectionState = {
          rows: {},
          count: 0,
          allSelected: _value
        };

        if (_value) {
          _.forEach(rows, function (row) {
            selectionState.rows[row.id] = _value;
          });

          selectionState.count = rows.length;
        }

        return _objectSpread(_objectSpread({}, state), {}, {
          selectionState: selectionState
        });
      }

    case 'UPDATE-TEXT-FILTER':
      {
        var _value2 = payload.value;
        return _objectSpread(_objectSpread({}, state), {}, {
          filterState: _objectSpread(_objectSpread({}, state.filterState), {}, {
            textFilter: _value2
          }),
          pageState: state.initialPageState
        });
      }

    case 'GO-TO-PAGE':
      {
        return _objectSpread(_objectSpread({}, state), {}, {
          pageState: {
            pageIndex: payload.index
          }
        });
      }
  }

  return state;
};

var useTable = (function (_ref) {
  var isSorting = _ref.isSorting,
      _ref$selectionType = _ref.selectionType,
      selectionType = _ref$selectionType === void 0 ? SELECTION_TYPE.NONE : _ref$selectionType,
      columns = _ref.columns,
      data = _ref.rows,
      externalSort = _ref.externalSort,
      externalFilter = _ref.externalFilter,
      defaultSortState = _ref.defaultSortState,
      _ref$pageSize = _ref.pageSize,
      pageSize = _ref$pageSize === void 0 ? 50 : _ref$pageSize,
      defaultSelectedRows = _ref.defaultSelectedRows;

  var _useMemo = useMemo(function () {
    var columnsMap = {};
    var pColumns = columns.map(function (column, index) {
      var pColumn = null;

      if (_.isString(column)) {
        pColumn = {
          id: column,
          accessor: column
        };
      } else {
        pColumn = _objectSpread(_objectSpread({}, column), {}, {
          id: _.isUndefined(column.id) ? index.toString() : column.id
        });
      }

      columnsMap[pColumn.id] = pColumn;
      return pColumn;
    });
    return {
      pColumns: pColumns,
      columnsMap: columnsMap
    };
  }, [columns]),
      pColumns = _useMemo.pColumns,
      columnsMap = _useMemo.columnsMap;

  var _useReducer = useReducer(reducer, {
    columns: columns,
    isSorting: isSorting,
    selectionType: selectionType,
    defaultSortState: defaultSortState,
    pageSize: pageSize
  }, init),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      table = _useReducer2[0],
      dispatch = _useReducer2[1];

  var toggleRowSelection = useCallback(function (id) {
    return function (value) {
      dispatch({
        type: 'TOGGLE-ROW-SELECTION',
        payload: {
          id: id,
          value: value
        }
      });
    };
  }, [dispatch]);
  var processedRows = useMemo(function () {
    return _.map(data, function (row, index) {
      var _table$selectionState;

      var id = _.isUndefined(row.id) ? index.toString() : row.id;
      var isSelected = ((_table$selectionState = table.selectionState) === null || _table$selectionState === void 0 ? void 0 : _table$selectionState.rows[id]) || false;
      var selectionCell = table.selectionState ? {
        selectionCell: /*#__PURE__*/React__default.createElement(SelectionCell, {
          selectionType: selectionType,
          isSelected: isSelected,
          disabled: row.disableSelection,
          onClick: function onClick() {
            return toggleRowSelection(id)(!isSelected);
          }
        }),
        cellProps: _objectSpread({
          onClick: selectionType === SELECTION_TYPE.SINGULAR && !row.disableSelection ? function () {
            return toggleRowSelection(id)(!isSelected);
          } : null
        }, row.cellProps)
      } : _objectSpread({}, row.cellProps);
      return _objectSpread(_objectSpread({}, row), {}, {
        id: id
      }, selectionCell);
    });
  }, [data, table, selectionType]);
  var shownColumns = useMemo(function () {
    return pColumns.filter(function (column) {
      var _table$columnState$co;

      return !((_table$columnState$co = table.columnState[column.id]) !== null && _table$columnState$co !== void 0 && _table$columnState$co.isHidden);
    });
  }, [pColumns, table.columnState]);

  var _toggleSort = useCallback(function (_ref2) {
    var id = _ref2.id;
    dispatch({
      type: 'TOGGLE-SORT',
      payload: {
        id: id
      }
    });
  }, [dispatch]);

  var updateFilterState = useCallback(function (payload) {
    dispatch({
      type: 'SET-FILTER',
      payload: payload
    });
  }, [dispatch]);
  var resetFilters = useCallback(function () {
    dispatch({
      type: 'RESET-FILTERS'
    });
  }, [dispatch]);
  var updateRowState = useCallback(function (id) {
    return function (state) {
      dispatch({
        type: 'UPDATE-ROW',
        payload: {
          id: id,
          state: state
        }
      });
    };
  }, [dispatch]);
  var updateTextFilter = useCallback(function (value) {
    dispatch({
      type: 'UPDATE-TEXT-FILTER',
      payload: {
        value: value
      }
    });
  }, [dispatch]);
  var filteredRows = useMemo(function () {
    if ((table.filterState.count > 0 || table.filterState.textFilter) && !externalFilter) {
      return filter(table.filterState, processedRows, columns, columnsMap);
    } else {
      return processedRows;
    }
  }, [table.filterState, processedRows, externalFilter, columns, columnsMap]);
  var organizedRows = useMemo(function () {
    if (isSorting && !externalSort) {
      return sort(table.sortState, columnsMap, filteredRows);
    } else {
      return filteredRows;
    }
  }, [isSorting, externalSort, filteredRows, table.sortState, columnsMap]);
  var selectAllRows = useCallback(function (value) {
    dispatch({
      type: 'TOGGLE-SELECT-ALL',
      payload: {
        value: value,
        rows: organizedRows
      }
    });
  }, [dispatch, organizedRows]);
  var pageChunks = useMemo(function () {
    if (pageSize) {
      return _.chunk(organizedRows, pageSize);
    } else {
      return null;
    }
  }, [organizedRows, pageSize]);
  var pagination = useMemo(function () {
    if (pageChunks) {
      var pageIndex = table.pageState.pageIndex;
      var pageCount = pageChunks.length;

      var gotoPage = function gotoPage(i) {
        if (i >= 0 && i < pageCount) {
          dispatch({
            type: 'GO-TO-PAGE',
            payload: {
              index: i
            }
          });
        }
      };

      return {
        pageIndex: pageIndex,
        pageRows: pageChunks[pageIndex],
        pageCount: pageCount,
        gotoPage: gotoPage
      };
    } else {
      return null;
    }
  }, [pageChunks, table.pageState, dispatch]);
  var processedColumns = useMemo(function () {
    return shownColumns.map(function (column) {
      var _table$sortState, _table$sortState2;

      return _objectSpread(_objectSpread({}, column), {}, {
        toggleSort: function toggleSort() {
          return _toggleSort({
            id: column.id
          });
        },
        sortState: column.id === ((_table$sortState = table.sortState) === null || _table$sortState === void 0 ? void 0 : _table$sortState.column) ? (_table$sortState2 = table.sortState) === null || _table$sortState2 === void 0 ? void 0 : _table$sortState2.sortOrder : null,
        filterState: table.filterState.columns[column.id],
        updateColumnFilter: function updateColumnFilter(values) {
          return updateFilterState({
            id: column.id,
            values: values
          });
        }
      });
    });
  }, [_toggleSort, table.tempColumns, table.sortState, updateFilterState, table.filterState]);
  var columnsWithSelection = useMemo(function () {
    return table.selectionState ? [{
      Header: '',
      accessor: 'selectionCell',
      id: 'selectionColumn',
      width: '60px'
    }].concat(_toConsumableArray(processedColumns)) : processedColumns;
  }, [processedColumns]);
  useRunOnceWhenTruthy(function () {
    defaultSelectedRows === null || defaultSelectedRows === void 0 ? void 0 : defaultSelectedRows.forEach(function (rowId) {
      toggleRowSelection(rowId)(true);
    });
  }, defaultSelectedRows);
  return useMemo(function () {
    return {
      rows: processedRows,
      organizedRows: organizedRows,
      columns: columnsWithSelection,
      sortState: table.sortState,
      filterState: table.filterState,
      tableState: table.tableState,
      rowState: table.rowState,
      selectionState: table.selectionState,
      toggleSort: _toggleSort,
      updateFilterState: updateFilterState,
      updateRowState: updateRowState,
      updateTextFilter: updateTextFilter,
      toggleRowSelection: toggleRowSelection,
      selectAllRows: selectAllRows,
      resetFilters: resetFilters,
      pagination: pagination
    };
  }, [table, organizedRows, _toggleSort, updateFilterState, updateRowState, updateTextFilter, toggleRowSelection, selectAllRows, processedRows, resetFilters, pagination]);
});

export default useTable;
//# sourceMappingURL=useTable.js.map
