import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import React__default from 'react';
import { NOTIFICATION_TYPES } from '../../consts.js';
import SvgNotificationWarningIcon from '../../assets/svgs/notification-warning-icon.svg.js';
import SvgNotificationErrorIcon from '../../assets/svgs/notification-error-icon.svg.js';
import SvgNotificationSucessIcon from '../../assets/svgs/notification-sucess-icon.svg.js';
import SvgCloseIcon from '../../assets/svgs/close-icon.svg.js';
import './notification.scss.js';
import ButtonBase from '../ButtonBase/index.js';
import PropTypes from 'prop-types';
import useToggle from '../../hooks/useToggle.js';
import SvgArrowRight from '../../assets/svgs/arrow-right.svg.js';

var SUCCESS = NOTIFICATION_TYPES.SUCCESS,
    WARNING = NOTIFICATION_TYPES.WARNING,
    ERROR = NOTIFICATION_TYPES.ERROR,
    INFO = NOTIFICATION_TYPES.INFO,
    WARNING_ERROR = NOTIFICATION_TYPES.WARNING_ERROR;
/** Notification  */

var Notification = function Notification(_ref) {
  var children = _ref.children,
      className = _ref.className,
      variant = _ref.variant,
      onRemove = _ref.onRemove,
      expandable = _ref.expandable,
      expandedDescription = _ref.expandedDescription;

  var _useToggle = useToggle(),
      _useToggle2 = _slicedToArray(_useToggle, 2),
      isExpanded = _useToggle2[0],
      toggleExpand = _useToggle2[1];

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-notification-widget ".concat(className, " Suc-").concat(variant === null || variant === void 0 ? void 0 : variant.toLowerCase(), "-notification")
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-top"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-notification-icon"
  }, (variant === WARNING || variant === INFO || variant === WARNING_ERROR) && /*#__PURE__*/React__default.createElement(SvgNotificationWarningIcon, null), variant === ERROR && /*#__PURE__*/React__default.createElement(SvgNotificationErrorIcon, null), variant === SUCCESS && /*#__PURE__*/React__default.createElement(SvgNotificationSucessIcon, null)), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-notification-content"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-notification-text ".concat(expandable ? 'Suc-ellipsis' : '')
  }, children), expandable && /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: 'Suc-show-more',
    onClick: toggleExpand
  }, /*#__PURE__*/React__default.createElement("span", {
    className: 'Suc-text'
  }, "Show ", isExpanded ? 'less' : 'more'), /*#__PURE__*/React__default.createElement(SvgArrowRight, {
    className: "Suc-caret-icon ".concat(isExpanded ? '' : 'Suc-down')
  }))), onRemove && /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: "Suc-remove-notification",
    onClick: onRemove
  }, /*#__PURE__*/React__default.createElement(SvgCloseIcon, null))), isExpanded && /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-bottom"
  }, expandedDescription));
};

Notification.propTypes = {
  /** variant of notification */
  variant: PropTypes.oneOf([SUCCESS, WARNING, ERROR, INFO, WARNING_ERROR]),

  /** custom className */
  className: PropTypes.string,

  /** notification text */
  children: PropTypes.node,

  /** should be an expandable notification */
  expandable: PropTypes.bool,

  /** if it is expandable, what should be the description */
  expandedDescription: PropTypes.node
};
Notification.defaultProps = {
  variant: 'SUCCESS',
  className: '',
  expandable: false
};

export default Notification;
//# sourceMappingURL=index.js.map
