import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import PropTypes from 'prop-types';
import FieldExtra from '../FieldExtra/index.js';
import './radioButton.scss.js';

var RadioButton = function RadioButton(_ref) {
  var children = _ref.children,
      error = _ref.error,
      warning = _ref.warning,
      checked = _ref.checked,
      disabled = _ref.disabled,
      className = _ref.className,
      disabledTitle = _ref.disabledTitle,
      rest = _objectWithoutProperties(_ref, ["children", "error", "warning", "checked", "disabled", "className", "disabledTitle"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-radio-container"
  }, /*#__PURE__*/React__default.createElement("label", {
    className: "Suc-radio-button ".concat(disabled ? 'Suc-disabled' : '', " ").concat(checked ? 'Suc-active' : '', " ").concat(className),
    title: disabled ? disabledTitle : ''
  }, /*#__PURE__*/React__default.createElement("input", _extends({
    className: 'Suc-radio-input',
    checked: checked,
    type: "radio",
    disabled: disabled
  }, rest)), /*#__PURE__*/React__default.createElement("svg", null, /*#__PURE__*/React__default.createElement("circle", {
    stroke: "1",
    cx: "8.5",
    cy: "8.5",
    r: "8",
    className: 'Suc-outer-circle'
  }), /*#__PURE__*/React__default.createElement("circle", {
    stroke: "none",
    cx: "8.5",
    cy: "8.5",
    r: "1",
    className: 'Suc-inner-circle'
  })), children), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning
  }));
};

RadioButton.propTypes = {
  /** checked or unchecked */
  checked: PropTypes.bool,

  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** radio option label */
  children: PropTypes.node,

  /** callback run on change */
  onChange: PropTypes.func,

  /** if disabled show tooltip with explanation */
  disabledTitle: PropTypes.node
};
RadioButton.defaultProps = {
  className: '',
  disabled: false
};

export default RadioButton;
//# sourceMappingURL=index.js.map
