import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import React__default, { useRef, useState } from 'react';
import PropTypes from 'prop-types';
import './searchInput.scss.js';
import debounce from 'lodash/debounce';
import ButtonBase from '../ButtonBase/index.js';
import SvgCloseThick from '../../assets/svgs/close-thick.svg.js';
import SvgSearch from '../../assets/svgs/search.svg.js';

var searchIntervalTime = 200;

var SearchInput = function SearchInput(_ref) {
  var className = _ref.className,
      alwaysOpen = _ref.alwaysOpen,
      setFilter = _ref.setFilter,
      placeholder = _ref.placeholder;
  var input = useRef(null);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = useState(''),
      _useState4 = _slicedToArray(_useState3, 2),
      value = _useState4[0],
      setValue = _useState4[1];

  var throttledSetFilter = debounce(function (value) {
    return setFilter(value);
  }, searchIntervalTime);

  var open = function open() {
    setIsOpen(true);
    setTimeout(function () {
      input.current.focus();
    });
  };

  var close = function close() {
    setIsOpen(false);
    setValue('');
    throttledSetFilter('');
  };

  var handleBlur = function handleBlur() {
    if (!value) close();
  };

  var handleChange = function handleChange(event) {
    var currValue = event.target.value;
    throttledSetFilter(currValue);
    setValue(currValue);
  };

  var handleKeyDown = function handleKeyDown(event) {
    var currValue = event.target.value;

    if (event.key === 'Enter') {
      throttledSetFilter(currValue);
    }
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-search-input ".concat(isOpen || alwaysOpen ? 'Suc-opened' : '', " ").concat(className)
  }, /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: "Suc-open-input",
    disabled: alwaysOpen,
    onClick: !alwaysOpen ? open : function () {}
  }, /*#__PURE__*/React__default.createElement(SvgSearch, null)), /*#__PURE__*/React__default.createElement("input", {
    placeholder: placeholder || 'Search',
    onBlur: function onBlur() {
      return handleBlur();
    },
    ref: input,
    value: value,
    onChange: handleChange,
    onKeyDown: handleKeyDown
  }), alwaysOpen ? null : /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: "Suc-close-input",
    onClick: close
  }, /*#__PURE__*/React__default.createElement(SvgCloseThick, null)));
};

SearchInput.propTypes = {
  /** Should Input be always open */
  alwaysOpen: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** filter function to update the state of list */
  setFilter: PropTypes.func,

  /** search input placeholder value */
  placeholder: PropTypes.string
};
SearchInput.defaultProps = {
  className: '',
  alwaysOpen: false
};

export default SearchInput;
//# sourceMappingURL=index.js.map
