import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import Select, { components } from 'react-select';
import SvgTriangle from '../../assets/svgs/triangle.svg.js';
import PropTypes from 'prop-types';
import TooltipInfo from '../TooltipInfo/index.js';
import FieldExtra from '../FieldExtra/index.js';
import './select.scss.js';

var DropdownIndicator = function DropdownIndicator() {
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-dropdown-indicator"
  }, /*#__PURE__*/React__default.createElement(SvgTriangle, null));
};

var DefaultSingleValue = function DefaultSingleValue(props) {
  return /*#__PURE__*/React__default.createElement(components.SingleValue, props);
};

var Option = function Option(props) {
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-custom-option",
    title: props.data.disabled ? props.data.disabledTitle : ''
  }, /*#__PURE__*/React__default.createElement(components.Option, props));
}; // Select drop down with variants: 'default', 'inline', 'underline'


var SelectField = function SelectField(props) {
  var error = props.error,
      warning = props.warning,
      label = props.label,
      options = props.options,
      isLoading = props.isLoading,
      isSearchable = props.isSearchable,
      className = props.className,
      info = props.info,
      CustomOptionLabel = props.CustomOptionLabel,
      CustomSingleValue = props.CustomSingleValue,
      placeholder = props.placeholder,
      value = props.value,
      variant = props.variant,
      disabled = props.disabled,
      removeBottomMargin = props.removeBottomMargin,
      infoProps = props.infoProps,
      rest = _objectWithoutProperties(props, ["error", "warning", "label", "options", "isLoading", "isSearchable", "className", "info", "CustomOptionLabel", "CustomSingleValue", "placeholder", "value", "variant", "disabled", "removeBottomMargin", "infoProps"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-Select-container ".concat(className, " ").concat(disabled ? 'Suc-disabled' : '', " ").concat(removeBottomMargin ? '' : 'Suc-bottom-margin')
  }, label && variant === 'default' && /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-select-top'
  }, label && /*#__PURE__*/React__default.createElement("label", null, label), info && /*#__PURE__*/React__default.createElement(TooltipInfo, infoProps, info)), /*#__PURE__*/React__default.createElement(Select, _extends({
    className: "Suc-Select ".concat(error && 'Suc-error', " Suc-").concat(variant),
    classNamePrefix: "Suc-Select",
    components: {
      DropdownIndicator: DropdownIndicator,
      Option: Option,
      SingleValue: CustomSingleValue || DefaultSingleValue
    },
    formatOptionLabel: CustomOptionLabel,
    defaultMenuIsOpen: false,
    onBlurResetsInput: false,
    onSelectResetsInput: false,
    captureMenuScroll: false,
    maxMenuHeight: 150,
    isSearchable: isSearchable,
    isClearable: false,
    placeholder: placeholder,
    options: options,
    value: value,
    isLoading: isLoading,
    isDisabled: disabled,
    isOptionDisabled: function isOptionDisabled(option) {
      return option.disabled;
    }
  }, rest)), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning
  }));
};

var optionShape = {
  label: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  disabled: PropTypes.bool,
  disabledTitle: PropTypes.string
};
SelectField.propTypes = {
  /** select's type */
  variant: PropTypes.oneOf(['default', 'underline', 'inline']),

  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** label */
  label: PropTypes.string,

  /** placeholder */
  placeholder: PropTypes.string,

  /** error text */
  error: PropTypes.string,

  /** warning text */
  warning: PropTypes.string,

  /** remove margin-bottom (to allow inline alignment) */
  removeBottomMargin: PropTypes.bool,

  /** options array */
  options: PropTypes.arrayOf(PropTypes.shape(optionShape)),

  /** selected option */
  value: PropTypes.shape(optionShape),

  /** show loader */
  isLoading: PropTypes.bool,

  /** allow search */
  isSearchable: PropTypes.bool,

  /** custom component for Option */
  CustomOptionLabel: PropTypes.func,

  /** custom component for Selected Value */
  CustomSingleValue: PropTypes.func,

  /** info tooltip */
  info: PropTypes.node,

  /** InfoTooltip props */
  infoProps: PropTypes.object
};
SelectField.defaultProps = {
  className: '',
  variant: 'default',
  error: '',
  warning: '',
  isSearchable: true,
  disabled: false,
  placeholder: ' - Select -',
  removeBottomMargin: false,
  infoProps: {}
};

export default SelectField;
//# sourceMappingURL=index.js.map
