import React__default from 'react';
import ButtonBase from '../ButtonBase/index.js';
import './toggleSelector.scss.js';
import PropTypes from 'prop-types';

var ToggleSelector = function ToggleSelector(_ref) {
  var value = _ref.value,
      className = _ref.className,
      onChange = _ref.onChange,
      disabled = _ref.disabled;
  var circleFill = value ? disabled ? '#93b3e5' : '#006DC9' : disabled ? '#F5F5F5' : '#C8C8C8';
  var circleTransform = value ? 'translate(17)' : 'translate(0)';
  var shadowOpacity = value ? 0 : 1;
  var railOpacity = value ? disabled ? 0.4 : 0.8 : 1;
  var railFill = value ? '#93b3e5' : disabled ? '#C8C8C8' : '#E0E0E0';
  return /*#__PURE__*/React__default.createElement(ButtonBase, {
    className: "Suc-toggle-selector ".concat(className),
    disabled: disabled,
    onClick: function onClick() {
      return onChange(!value);
    },
    type: "button"
  }, /*#__PURE__*/React__default.createElement("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "40",
    height: "23",
    viewBox: "0 0 40 24"
  }, /*#__PURE__*/React__default.createElement("defs", null, /*#__PURE__*/React__default.createElement("filter", {
    id: "prefix__a",
    width: "172.2%",
    height: "172.2%",
    x: "-30.6%",
    y: "-30.6%",
    filterUnits: "objectBoundingBox"
  }, /*#__PURE__*/React__default.createElement("feOffset", {
    dx: "1",
    dy: "1",
    "in": "SourceAlpha",
    result: "shadowOffsetOuter1"
  }), /*#__PURE__*/React__default.createElement("feGaussianBlur", {
    "in": "shadowOffsetOuter1",
    result: "shadowBlurOuter1",
    stdDeviation: "2"
  }), /*#__PURE__*/React__default.createElement("feColorMatrix", {
    "in": "shadowBlurOuter1",
    values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.35 0"
  }))), /*#__PURE__*/React__default.createElement("g", {
    fill: "none",
    transform: "translate(1 2)"
  }, /*#__PURE__*/React__default.createElement("path", {
    className: "Suc-toggle-transition",
    fill: railFill,
    opacity: railOpacity,
    d: "M6.782 3.5h22.436c3.39-.076 6.202 2.61 6.282 6-.08 3.39-2.891 6.076-6.282 6H6.782C3.392 15.576.58 12.89.5 9.5c.08-3.39 2.891-6.076 6.282-6z"
  }), /*#__PURE__*/React__default.createElement("circle", {
    className: "Suc-toggle-transition",
    transform: circleTransform,
    opacity: shadowOpacity,
    fill: "#000",
    cx: "9.5",
    cy: "9.5",
    r: "9",
    filter: "url(#prefix__a)"
  }), /*#__PURE__*/React__default.createElement("circle", {
    className: "Suc-toggle-transition",
    fill: circleFill,
    transform: circleTransform,
    cx: "9.5",
    cy: "9.5",
    r: "9"
  }))));
};

ToggleSelector.propTypes = {
  /** toggle state */
  value: PropTypes.bool,

  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** callback called on change */
  onChange: PropTypes.func
};
ToggleSelector.defaultProps = {
  className: '',
  onChange: function onChange() {}
};

export default ToggleSelector;
//# sourceMappingURL=index.js.map
